eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
    & eval 'exec perl -S $0 $argv:q'
    if 0;

# $Id: run_test.pl 5502 2012-04-12 19:08:14Z johnsonb $
# -*- perl -*-

use Env (DDS_ROOT);
use lib "$DDS_ROOT/bin";
use Env (ACE_ROOT);
use lib "$ACE_ROOT/bin";
use PerlDDS::Run_Test;

$status = 0;

my $debug = 10;
my $transportDebug = 10;
my $debugFile = "debug.out";
my $is_rtps_disc = 0;
my $DCPScfg = "";

if ($ARGV[0] eq "rtps_disc") {
  $DCPScfg = $ARGV[0] . ".ini";
  $is_rtps_disc = 1;
} elsif ($ARGV[0] eq "rtps_disc_tcp") {
  $DCPScfg = $ARGV[0] . ".ini";
  $is_rtps_disc = 1;
}

my $debugOpts = "";

$debugOpts .= "-DCPSDebugLevel $debug " if $debug;
$debugOpts .= "-DCPSTransportDebugLevel $transportDebug " if $transportDebug;
$debugOpts .= "-ORBLogFile $debugFile " if $debugFile and ($debug or $transportDebug);

my $opts;

$opts .= " " . $debugOpts if $debug or $transportDebug;

$pub_opts = "$opts -DCPSConfigFile " .  ($is_rtps_disc ? $DCPScfg : "pub.ini");
$sub_opts = "$opts -DCPSConfigFile " .  ($is_rtps_disc ? $DCPScfg : "sub.ini");

$dcpsrepo_ior = "repo.ior";
$repo_bit_opt = $opts;

unlink $dcpsrepo_ior;
unlink $debugFile;

unless ($is_rtps_disc) {
  $DCPSREPO = PerlDDS::create_process ("$ENV{DDS_ROOT}/bin/DCPSInfoRepo",
                                      "$repo_bit_opt -o $dcpsrepo_ior ");
}

$Subscriber = PerlDDS::create_process ("subscriber", "$sub_opts");
$Publisher = PerlDDS::create_process ("publisher", "$pub_opts");

print $DCPSREPO->CommandLine() . "\n" unless ($is_rtps_disc);
print $Publisher->CommandLine() . "\n";
print $Subscriber->CommandLine() . "\n";

unless ($is_rtps_disc) {
  $DCPSREPO->Spawn ();
  if (PerlACE::waitforfile_timed ($dcpsrepo_ior, 30) == -1) {
      print STDERR "ERROR: waiting for Info Repo IOR file\n";
      $DCPSREPO->Kill ();
      exit 1;
  }
}

$Publisher->Spawn ();

$Subscriber->Spawn ();

$PublisherResult = $Publisher->WaitKill (300);
if ($PublisherResult != 0) {
    print STDERR "ERROR: publisher returned $PublisherResult \n";
    $status = 1;
  }

$SubscriberResult = $Subscriber->WaitKill (15);
if ($SubscriberResult != 0) {
    print STDERR "ERROR: subscriber returned $SubscriberResult \n";
    $status = 1;
}

unless ($is_rtps_disc) {
  $ir = $DCPSREPO->TerminateWaitKill(5);
  if ($ir != 0) {
      print STDERR "ERROR: DCPSInfoRepo returned $ir\n";
      $status = 1;
  }
  unlink $dcpsrepo_ior;
}


if ($status == 0) {
  print "test PASSED.\n";
} else {
  print STDERR "test FAILED.\n";
}

exit $status;
