# -*- Makefile -*-

#----------------------------------------------------------------------------
#
#       $Id: rules.dds.GNU 5637 2012-06-01 19:32:59Z harrisb $
#
#       Common Makefile rules for all of DDS
#
#----------------------------------------------------------------------------

# This is a multiple-include guard for this file because older versions of
# ACE's gnuace template will do an automatic include of this file as well
# as the one that will be generated by the verbatim in dcps.mpb.
ifndef rules_dds_gnu_included
rules_dds_gnu_included=1


ifndef TAO_ROOT
  TAO_ROOT = $(ACE_ROOT)/TAO
endif

ifndef DDS_ROOT
  DDS_ROOT = $(TAO_ROOT)/DDS
endif
DDS_ROOT := $(subst \,/,$(DDS_ROOT))

ifeq (,$(findstring -L$(DDS_ROOT)/lib,$(LDFLAGS)))
  LDFLAGS += -L$(DDS_ROOT)/lib
endif
ifeq (,$(findstring -I$(DDS_ROOT),$(INCLDIRS)))
  INCLDIRS += -I$(DDS_ROOT)
endif

# Set defaults for gnumake macros corresponding to MPC features used by DDS
# This is needed for features used in requires/avoids statements in .mpc files
built_in_topics ?= 1
tao_orbsvcs ?= 1
query_condition ?= 1
content_filtered_topic ?= 1
multi_topic ?= 1
ownership_profile ?= 1
ownership_kind_exclusive ?= 1
object_model_profile ?= 1
persistence_profile ?= 1
exceptions ?= 1

# Turn on symbol versioning. The scheme that we follow is to allow
# applications dependent on libraries, with same version numbers (major,
# minor and beta) to run, but applications with dependencies on libraries
# with different minor or major or beta versions to fail.
#
ifeq (cmd,$(findstring cmd,$(SHELL)))
DDS_MAJOR_VERSION := $(shell awk "/DDS_MAJOR_VERSION/ { print $$3}" ${DDS_ROOT}/dds/Version.h)
DDS_MINOR_VERSION := $(shell awk "/DDS_MINOR_VERSION/ { print $$3}" ${DDS_ROOT}/dds/Version.h)
DDS_MICRO_VERSION := $(shell awk "/DDS_MICRO_VERSION/ { print $$3}" ${DDS_ROOT}/dds/Version.h)
else
DDS_MAJOR_VERSION := $(shell awk '/DDS_MAJOR_VERSION/ { print $$3}' ${DDS_ROOT}/dds/Version.h)
DDS_MINOR_VERSION := $(shell awk '/DDS_MINOR_VERSION/ { print $$3}' ${DDS_ROOT}/dds/Version.h)
DDS_MICRO_VERSION := $(shell awk '/DDS_MICRO_VERSION/ { print $$3}' ${DDS_ROOT}/dds/Version.h)
endif

GNUACE_PROJECT_VERSION ?= $(DDS_MAJOR_VERSION).$(DDS_MINOR_VERSION).$(DDS_MICRO_VERSION)

# Version number of the libraries
#
ifeq ($(versioned_so),1)
  # Only set SOVERSION for DDS if versioning is turned on and SOVERION is
  # blank, which gives users to ability to override it.
  ifeq ($(SOVERSION),)
    SOVERSION = .$(DDS_MAJOR_VERSION).$(DDS_MINOR_VERSION).$(DDS_MICRO_VERSION)
  endif # SOVERSION

  # Name that will be written into the dynamic library
  #
  ifneq ($(SONAME),)
    SONAME = $(SHLIB).$(DDS_MAJOR_VERSION).$(DDS_MINOR_VERSION).$(DDS_MICRO_VERSION)
  endif # SONAME
endif # versioned_so

-include $(DDS_ROOT)/user_macros.GNU

# user_macros.GNU may not exist, but GNU make will try to "make" it using the
# overly general rule for creating symlinks in rules.local.GNU.  To prevent
# this, create a more specific rule for user_macros.GNU that does nothing.
.DEFAULT_GOAL := all
$(DDS_ROOT)/user_macros.GNU: ;

endif # rules_dds_gnu_included
