/*
 * $Id: TransportManager.java 4836 2011-08-06 01:11:10Z calabrese_p $
 *
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

package org.opendds.jms.transport;

import javax.jms.JMSException;

import OpenDDS.DCPS.transport.TransportConfig;

/**
 * @author Steven Stallion
 * @version $Revision: 4836 $
 */
public class TransportManager {
    private TransportFactory tf;
    private TransportConfig transport;

    public TransportManager(TransportFactory tf) {
        assert tf != null;

        this.tf = tf;
    }

    protected void createTransport() throws JMSException {
        transport = tf.createTransport();
    }

    public synchronized TransportConfig getTransport() throws JMSException {
        if (transport == null) {
            createTransport();
        }
        return transport;
    }
}
