/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.merge;

import java.util.Iterator;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.XmlMerger;
import org.codehaus.cargo.module.merge.DescriptorMergerByTag;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.module.webapp.elements.FilterMapping;
import org.codehaus.cargo.util.CargoException;

public class WebXmlMerger
extends XmlMerger {
    private WebXml webXml;
    private DescriptorMergerByTag descriptorMergerByTag = new DescriptorMergerByTag();

    public WebXmlMerger() {
        this.descriptorMergerByTag.setStrategy("login-config", DescriptorMergerByTag.OVERWRITE);
        this.descriptorMergerByTag.setStrategy("filter", DescriptorMergerByTag.IGNORE);
        this.descriptorMergerByTag.setStrategy("filter-mapping", DescriptorMergerByTag.IGNORE);
        this.descriptorMergerByTag.setStrategy("servlet", DescriptorMergerByTag.IGNORE);
        this.addMerger(this.descriptorMergerByTag);
    }

    public WebXmlMerger(Descriptor base) {
        this();
        this.init(base);
    }

    public void init(Descriptor base) {
        this.webXml = (WebXml)base;
        this.descriptorMergerByTag.setDescriptorType(base.getDescriptorType());
        super.init(base);
    }

    public final void merge(Descriptor theMerge) {
        try {
            WebXml theMergeWebXml = (WebXml)theMerge;
            this.checkServletVersions(theMergeWebXml);
            super.merge(theMerge);
            if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
                this.mergeFilters(theMergeWebXml);
            }
            this.mergeServlets(theMergeWebXml);
            this.mergeSecurityRoles(theMergeWebXml);
        }
        catch (Exception e) {
            throw new MergeException("Exception merging web.xml files", e);
        }
    }

    protected VendorWebAppDescriptor getVendorWebAppDescriptor(WebXml theWebXml, Class clazz) {
        Iterator i = theWebXml.getVendorDescriptors();
        while (i.hasNext()) {
            VendorWebAppDescriptor descriptor = (VendorWebAppDescriptor)i.next();
            if (!clazz.isInstance(descriptor)) continue;
            return descriptor;
        }
        return null;
    }

    protected final void checkServletVersions(WebXml theWebXml) {
        if (this.webXml.getVersion() != null && this.webXml.getVersion().compareTo(theWebXml.getVersion()) < 0) {
            this.getLogger().warn("Merging elements from a version " + theWebXml.getVersion() + " descriptor into a version " + this.webXml.getVersion() + ", some elements may be skipped", this.getClass().getName());
        }
    }

    protected final void mergeFilters(WebXml theWebXml) {
        Iterator filterNames = WebXmlUtils.getFilterNames(theWebXml);
        int count = 0;
        while (filterNames.hasNext()) {
            String filterName = (String)filterNames.next();
            if (!WebXmlUtils.hasFilter(this.webXml, filterName)) {
                WebXmlUtils.addFilter(this.webXml, WebXmlUtils.getFilter(theWebXml, filterName));
            } else {
                Iterator filterInitParamNames = WebXmlUtils.getFilterInitParamNames(theWebXml, filterName);
                while (filterInitParamNames.hasNext()) {
                    String paramName = (String)filterInitParamNames.next();
                    String paramValue = WebXmlUtils.getFilterInitParam(theWebXml, filterName, paramName);
                    WebXmlUtils.addFilterInitParam(this.webXml, filterName, paramName, paramValue);
                }
            }
            Iterator filterMappings = WebXmlUtils.getFilterMappingElements(theWebXml, filterName);
            while (filterMappings.hasNext()) {
                FilterMapping mapping = (FilterMapping)((Object)filterMappings.next());
                WebXmlUtils.addFilterMapping(this.webXml, mapping);
            }
            ++count;
        }
        this.getLogger().debug("Merged " + count + " filter definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }

    protected final void mergeServlets(WebXml theWebXml) throws CargoException {
        try {
            Iterator servletNames = WebXmlUtils.getServletNames(theWebXml);
            int count = 0;
            while (servletNames.hasNext()) {
                String servletName = (String)servletNames.next();
                if (!WebXmlUtils.hasServlet(this.webXml, servletName)) {
                    WebXmlUtils.addServlet(this.webXml, WebXmlUtils.getServlet(theWebXml, servletName));
                } else {
                    Iterator servletInitParamNames = WebXmlUtils.getServletInitParamNames(theWebXml, servletName);
                    while (servletInitParamNames.hasNext()) {
                        String paramName = (String)servletInitParamNames.next();
                        String paramValue = WebXmlUtils.getServletInitParam(theWebXml, servletName, paramName);
                        WebXmlUtils.addServletInitParam(this.webXml, servletName, paramName, paramValue);
                    }
                    String roleName = WebXmlUtils.getServletRunAsRoleName(theWebXml, servletName);
                    if (roleName != null) {
                        WebXmlUtils.addServletRunAsRoleName(this.webXml, servletName, roleName);
                    }
                }
                Iterator servletMappings = WebXmlUtils.getServletMappings(theWebXml, servletName);
                while (servletMappings.hasNext()) {
                    String urlPattern = (String)servletMappings.next();
                    WebXmlUtils.addServletMapping(this.webXml, servletName, urlPattern);
                }
                ++count;
            }
            this.getLogger().debug("Merged " + count + " servlet definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
        }
        catch (Exception ex) {
            throw new CargoException("Exception merging servlet definitions", ex);
        }
    }

    protected final void mergeSecurityRoles(WebXml theWebXml) {
        Iterator securityRoleNames = WebXmlUtils.getSecurityRoleNames(theWebXml);
        int count = 0;
        while (securityRoleNames.hasNext()) {
            String securityRoleName = (String)securityRoleNames.next();
            if (WebXmlUtils.hasSecurityRole(this.webXml, securityRoleName)) continue;
            WebXmlUtils.addSecurityRole(this.webXml, securityRoleName);
        }
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " security roles into the descriptor", this.getClass().getName());
        }
    }
}

