/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.merge;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.merge.ArchiveResourceMerger;
import org.codehaus.cargo.module.webapp.merge.MergeWarFileDetails;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.JarUtils;
import org.jdom.JDOMException;

public class MergedWarArchive
implements WarArchive {
    private List warFiles = new ArrayList();
    private List jarFiles = new ArrayList();
    private boolean mergeJarFiles = true;
    private WebXml mergedWebXml;
    private List mergeProcessors = new ArrayList();
    private WebXmlMerger webXmlMerger;

    MergedWarArchive() {
    }

    protected WarArchive firstWarFile() {
        return ((MergeWarFileDetails)this.warFiles.get(0)).getWarFile();
    }

    public void addProcessor(String path, MergeProcessor merger) {
        this.mergeProcessors.add(new ArchiveResourceMerger(path, merger));
    }

    void add(WarArchive warFile) {
        this.warFiles.add(new MergeWarFileDetails(warFile));
    }

    void addJar(File jarFile) {
        this.jarFiles.add(jarFile);
    }

    public WebXmlMerger getWebXmlMerger() throws IOException, JDOMException {
        if (this.webXmlMerger == null) {
            this.webXmlMerger = new WebXmlMerger(this.firstWarFile().getWebXml());
        }
        return this.webXmlMerger;
    }

    public WebXml getWebXml() throws IOException, JDOMException {
        if (this.mergedWebXml == null) {
            WebXmlMerger wxm = this.getWebXmlMerger();
            for (int i = 1; i < this.warFiles.size(); ++i) {
                MergeWarFileDetails details = (MergeWarFileDetails)this.warFiles.get(i);
                WarArchive wa = details.getWarFile();
                wxm.merge(wa.getWebXml());
            }
            this.mergedWebXml = this.firstWarFile().getWebXml();
        }
        return this.mergedWebXml;
    }

    protected void executeMergeProcessors(File assembleDir) throws MergeException, IOException {
        Iterator i = this.mergeProcessors.iterator();
        while (i.hasNext()) {
            ArchiveResourceMerger processor = (ArchiveResourceMerger)i.next();
            for (int j = 0; j < this.warFiles.size(); ++j) {
                MergeWarFileDetails details = (MergeWarFileDetails)this.warFiles.get(j);
                WarArchive wa = details.getWarFile();
                processor.addMergeItem(wa);
            }
            processor.execute(assembleDir);
        }
    }

    public void store(File warFile) throws MergeException, IOException, JDOMException {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        WebXml mergedWebXml = this.getWebXml();
        String assembleDir = fileHandler.createUniqueTmpDirectory();
        this.expandToPath(assembleDir);
        if (!this.mergeJarFiles) {
            File f = new File(assembleDir);
            File webInfLib = new File(f, "WEB-INF/lib");
            File[] files = webInfLib.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || !files[i].getName().toLowerCase().endsWith(".jar")) continue;
                fileHandler.delete(files[i].getAbsolutePath());
            }
        }
        this.copyJars(assembleDir);
        WebXmlIo.writeAll(mergedWebXml, fileHandler.append(new File(assembleDir).getAbsolutePath(), File.separator + "WEB-INF"));
        this.executeMergeProcessors(new File(assembleDir));
        JarUtils jarUtils = new JarUtils();
        jarUtils.createJarFromDirectory(assembleDir, warFile);
        fileHandler.delete(assembleDir);
    }

    private void copyJars(String assembleDir) {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        File f = new File(assembleDir);
        File webInfLib = new File(f, "WEB-INF/lib");
        webInfLib.mkdirs();
        Iterator i = this.jarFiles.iterator();
        while (i.hasNext()) {
            File sourceFile = (File)i.next();
            fileHandler.copyFile(sourceFile.getAbsolutePath(), new File(webInfLib, sourceFile.getName()).getAbsolutePath());
        }
    }

    public boolean containsClass(String theClassName) throws IOException {
        Iterator i = this.warFiles.iterator();
        while (i.hasNext()) {
            MergeWarFileDetails details = (MergeWarFileDetails)i.next();
            WarArchive wa = details.getWarFile();
            if (!wa.containsClass(theClassName)) continue;
            return true;
        }
        return false;
    }

    public String findResource(String theName) throws IOException {
        Iterator i = this.warFiles.iterator();
        while (i.hasNext()) {
            MergeWarFileDetails details = (MergeWarFileDetails)i.next();
            WarArchive wa = details.getWarFile();
            String res = wa.findResource(theName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public InputStream getResource(String thePath) throws IOException {
        Iterator i = this.warFiles.iterator();
        while (i.hasNext()) {
            MergeWarFileDetails details = (MergeWarFileDetails)i.next();
            WarArchive wa = details.getWarFile();
            InputStream is = wa.getResource(thePath);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public List getResources(String thePath) throws IOException {
        ArrayList results = new ArrayList();
        Iterator i = this.warFiles.iterator();
        while (i.hasNext()) {
            MergeWarFileDetails details = (MergeWarFileDetails)i.next();
            WarArchive wa = details.getWarFile();
            results.addAll(wa.getResources(thePath));
        }
        return results;
    }

    public void expandToPath(String path) throws IOException {
        this.expandToPath(path, null);
    }

    public void expandToPath(String path, FileFilter filter) throws IOException {
        for (int i = 0; i < this.warFiles.size(); ++i) {
            MergeWarFileDetails details = (MergeWarFileDetails)this.warFiles.get(i);
            WarArchive wa = details.getWarFile();
            wa.expandToPath(path, filter);
        }
    }

    public void mergeJarFiles(boolean mergeJarFiles) {
        this.mergeJarFiles = mergeJarFiles;
    }
}

