/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXml22Type;
import org.codehaus.cargo.module.webapp.WebXml23Type;
import org.codehaus.cargo.module.webapp.WebXml24Type;
import org.codehaus.cargo.module.webapp.WebXmlType;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.util.CargoException;
import org.jdom.JDOMException;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlTypeAwareParser
extends DefaultHandler {
    protected WebXmlVersion version;
    private BufferedInputStream bufferedStream;
    private EntityResolver theEntityResolver;
    private WebXml webXml;

    public WebXmlTypeAwareParser(InputStream theInput, EntityResolver theEntityResolver) {
        this.bufferedStream = new BufferedInputStream(theInput);
        this.theEntityResolver = theEntityResolver;
    }

    public WebXml parse() throws IOException, JDOMException {
        this.bufferedStream.mark(0x100000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.bufferedStream));
        String line = reader.readLine();
        while (line != null && this.version == null) {
            if (line.indexOf(WebXmlVersion.V2_2.getPublicId()) != -1) {
                this.version = WebXmlVersion.V2_2;
            }
            if (line.indexOf(WebXmlVersion.V2_3.getPublicId()) != -1) {
                this.version = WebXmlVersion.V2_3;
            }
            if (line.indexOf("<web-app") != -1) break;
            line = reader.readLine();
        }
        if (this.version != null) {
            this.generateWebXml();
        } else {
            try {
                this.bufferedStream.reset();
                this.bufferedStream.mark(0x100000);
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(new InputSource(this.bufferedStream), (DefaultHandler)this);
            }
            catch (SAXException e) {
            }
            catch (Exception ex) {
                throw new CargoException("Problem in parsing", ex);
            }
        }
        return this.webXml;
    }

    private void generateWebXml() throws IOException, JDOMException {
        this.bufferedStream.reset();
        WebXmlType descriptorType = WebXml23Type.getInstance();
        if (WebXmlVersion.V2_2.equals(this.getVersion())) {
            descriptorType = WebXml22Type.getInstance();
        } else if (WebXmlVersion.V2_4.equals(this.getVersion())) {
            descriptorType = WebXml24Type.getInstance();
        }
        this.webXml = (WebXml)descriptorType.getDescriptorIo().parseXml(this.bufferedStream, this.theEntityResolver);
    }

    public void notationDecl(String namespaceURI, String sName, String qName) throws SAXException {
    }

    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        try {
            String xmlNs = attrs.getValue("xmlns");
            String version = attrs.getValue("version");
            if (WebXmlVersion.V2_4.getNamespace().getURI().equals(xmlNs)) {
                this.version = WebXmlVersion.V2_4;
            }
            this.generateWebXml();
        }
        catch (Exception ex) {
            throw new CargoException("Problem in parsing web xml file", ex);
        }
        throw new SAXException("Finished examining file - stop the parser");
    }

    public WebXmlVersion getVersion() {
        return this.version;
    }
}

