/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXml;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXmlIo;
import org.codehaus.cargo.module.webapp.orion.OrionWebXml;
import org.codehaus.cargo.module.webapp.orion.OrionWebXmlIo;
import org.codehaus.cargo.module.webapp.resin.ResinWebXml;
import org.codehaus.cargo.module.webapp.resin.ResinWebXmlIo;
import org.codehaus.cargo.module.webapp.weblogic.WeblogicXml;
import org.codehaus.cargo.module.webapp.weblogic.WeblogicXmlIo;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmi;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmiIo;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.jdom.JDOMException;

public class DefaultWarArchive
extends DefaultJarArchive
implements WarArchive {
    private WebXml webXml;
    private String file;

    public DefaultWarArchive(String file) {
        super(file);
        this.file = file;
    }

    public DefaultWarArchive(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public final WebXml getWebXml() throws IOException, JDOMException {
        if (this.webXml == null) {
            InputStream in = null;
            try {
                in = this.getResource("WEB-INF/web.xml");
                this.webXml = in != null ? WebXmlIo.parseWebXml(in, null) : new WebXml();
            }
            catch (Exception ex) {
                throw new CargoException("Error parsing the web.xml file in " + this.file, ex);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.addWeblogicDescriptor();
            this.addOracleDescriptor();
            this.addWebsphereDescriptor();
            this.addResinDescriptor();
            this.addJBossDescriptor();
        }
        return this.webXml;
    }

    public final void store(File warFile) throws IOException, JDOMException {
        JarEntry entry;
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        JarInputStream in = this.getContentAsStream();
        JarOutputStream out = new JarOutputStream(new FileOutputStream(warFile));
        ArrayList<String> descriptorNames = new ArrayList<String>();
        descriptorNames.add("WEB-INF/" + this.getWebXml().getFileName());
        Iterator vendorDescriptors = this.getWebXml().getVendorDescriptors();
        while (vendorDescriptors.hasNext()) {
            descriptorNames.add("WEB-INF/" + ((Descriptor)vendorDescriptors.next()).getFileName());
        }
        while ((entry = in.getNextJarEntry()) != null) {
            if (descriptorNames.contains(entry.getName())) continue;
            out.putNextEntry(entry);
            fileHandler.copy(in, out);
        }
        in.close();
        JarEntry webXmlEntry = new JarEntry("WEB-INF/" + this.getWebXml().getFileName());
        out.putNextEntry(webXmlEntry);
        AbstractDescriptorIo.writeDescriptor((Descriptor)this.getWebXml(), out, null, true);
        Iterator descriptors = this.getWebXml().getVendorDescriptors();
        while (descriptors.hasNext()) {
            Descriptor descriptor = (Descriptor)descriptors.next();
            JarEntry descriptorEntry = new JarEntry("WEB-INF/" + descriptor.getFileName());
            out.putNextEntry(descriptorEntry);
            AbstractDescriptorIo.writeDescriptor(descriptor, out, null, true);
        }
        out.close();
    }

    public final boolean containsClass(String className) throws IOException {
        boolean containsClass = false;
        String resourceName = "WEB-INF/classes/" + className.replace('.', '/') + ".class";
        if (this.getResource(resourceName) != null) {
            containsClass = true;
        }
        List jars = this.getResources("WEB-INF/lib/");
        Iterator i = jars.iterator();
        while (i.hasNext()) {
            DefaultJarArchive jar = new DefaultJarArchive(this.getResource((String)i.next()));
            if (!jar.containsClass(className)) continue;
            containsClass = true;
        }
        return containsClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWeblogicDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            WeblogicXml descr;
            in = this.getResource("WEB-INF/weblogic.xml");
            if (in != null && (descr = WeblogicXmlIo.parseWeblogicXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResinDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            ResinWebXml descr;
            in = this.getResource("WEB-INF/resin-web.xml");
            if (in != null && (descr = ResinWebXmlIo.parseResinXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOracleDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            OrionWebXml descr;
            in = this.getResource("WEB-INF/orion-web.xml");
            if (in != null && (descr = OrionWebXmlIo.parseOrionXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWebsphereDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            IbmWebBndXmi descr;
            in = this.getResource("WEB-INF/ibm-web-bnd.xmi");
            if (in != null && (descr = IbmWebBndXmiIo.parseIbmWebBndXmi(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJBossDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            JBossWebXml descr;
            in = this.getResource("WEB-INF/jboss-web.xml");
            if (in != null && (descr = JBossWebXmlIo.parseJBossWebXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

