/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DtdParseException;
import org.codehaus.cargo.module.Grammar;
import org.codehaus.cargo.module.XmlEntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;

public class Dtd
implements Grammar {
    private Map elementOrders;

    public Dtd(String systemId) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new XmlEntityResolver());
            DtdHandler dtdHandler = new DtdHandler();
            try {
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", dtdHandler);
            }
            catch (SAXNotRecognizedException e) {
                throw new SAXException(e);
            }
            String xml = "<!DOCTYPE dummy SYSTEM \"" + systemId + "\"><dummy/>";
            reader.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
            this.elementOrders = dtdHandler.getElementOrders();
        }
        catch (IOException e) {
            throw new DtdParseException("Failed to read dtd", e);
        }
        catch (SAXException e) {
            throw new DtdParseException("Failed to parse dtd", e);
        }
        catch (ParserConfigurationException e) {
            throw new DtdParseException("Failed to parse dtd", e);
        }
    }

    public List getElementOrder(String tagName) {
        return (List)this.elementOrders.get(tagName);
    }

    private static class DtdHandler
    implements DeclHandler {
        private Map elementOrders = new HashMap();

        private DtdHandler() {
        }

        public void attributeDecl(String eName, String aName, String type, String mode, String value) {
        }

        public void elementDecl(String name, String model) {
            ArrayList<DescriptorTag> elements = new ArrayList<DescriptorTag>();
            if (!model.equals("EMPTY") && !model.equals("(#PCDATA)")) {
                StringTokenizer st = new StringTokenizer(model, ",()| ");
                while (st.hasMoreTokens()) {
                    boolean multipleAllowed = false;
                    String element = st.nextToken();
                    if (element.endsWith("*") || element.endsWith("+")) {
                        element = element.substring(0, element.length() - 1);
                        multipleAllowed = true;
                    }
                    if (element.endsWith("?")) {
                        element = element.substring(0, element.length() - 1);
                    }
                    DescriptorTag tag = new DescriptorTag(null, element, multipleAllowed);
                    elements.add(tag);
                }
            }
            this.elementOrders.put(name, elements);
        }

        public void externalEntityDecl(String name, String publicId, String systemId) {
        }

        public void internalEntityDecl(String name, String value) {
        }

        public Map getElementOrders() {
            return this.elementOrders;
        }
    }
}

