/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.module.DescriptorElement;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.Identifier;
import org.codehaus.cargo.util.CargoException;
import org.jdom.Namespace;

public class DescriptorTag {
    private DescriptorType descriptorType;
    private String tagName;
    private Namespace tagNamespace;
    private boolean multipleAllowed;
    private Identifier identifier;
    private Class implementationClass;

    public DescriptorTag(DescriptorType descriptorType, String tagName, Namespace namespace, boolean isMultipleAllowed, Identifier identifier, Class clazz) {
        this.descriptorType = descriptorType;
        this.tagName = tagName;
        this.tagNamespace = namespace;
        this.multipleAllowed = isMultipleAllowed;
        this.identifier = identifier;
        this.implementationClass = clazz;
        if (this.descriptorType != null) {
            descriptorType.addTag(this);
        }
    }

    public DescriptorTag(DescriptorType descriptorType, String tagName, boolean isMultipleAllowed) {
        this(descriptorType, tagName, null, isMultipleAllowed, null, null);
    }

    public boolean equals(Object other) {
        DescriptorTag tag;
        boolean eq = false;
        if (other instanceof DescriptorTag && (tag = (DescriptorTag)other).getTagName().equals(this.tagName)) {
            eq = true;
        }
        return eq;
    }

    public int hashCode() {
        return this.getTagName().hashCode();
    }

    public String getTagName() {
        return this.tagName;
    }

    public Namespace getTagNamespace() {
        return this.tagNamespace;
    }

    public boolean isMultipleAllowed() {
        return this.multipleAllowed;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Class getImplementationClass() {
        return this.implementationClass;
    }

    public DescriptorType getDescriptorType() {
        return this.descriptorType;
    }

    public String toString() {
        return this.getTagName();
    }

    public DescriptorElement create() throws CargoException {
        DescriptorElement returnValue = null;
        if (this.implementationClass == null) {
            returnValue = new DescriptorElement(this);
        } else {
            Constructor<?>[] constructors = this.implementationClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> cons = constructors[i];
                if (cons.getParameterTypes().length != 1) continue;
                try {
                    if (!cons.getParameterTypes()[0].isAssignableFrom(this.getClass())) continue;
                    returnValue = (DescriptorElement)((Object)cons.newInstance(this));
                    break;
                }
                catch (Exception ex) {
                    throw new CargoException("Error instantiating class for " + this.getTagName());
                }
            }
        }
        return returnValue;
    }
}

