/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.cargo.module.DescriptorElement;
import org.codehaus.cargo.module.DescriptorIo;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.Grammar;
import org.codehaus.cargo.util.CargoException;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;

public class AbstractDescriptorType
extends DefaultJDOMFactory
implements JDOMFactory,
DescriptorType {
    private DescriptorType parent;
    private Grammar grammar;
    private List tags;
    private Class descriptorClass;
    private DescriptorIo descriptorIo;

    protected AbstractDescriptorType(DescriptorType parent, Class descriptorClass, Grammar grammar) {
        this.parent = parent;
        this.grammar = grammar;
        this.descriptorClass = descriptorClass;
        this.tags = new ArrayList();
    }

    public DescriptorIo getDescriptorIo() {
        return this.descriptorIo;
    }

    protected void setDescriptorIo(DescriptorIo descriptorIo) {
        this.descriptorIo = descriptorIo;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void addTag(DescriptorTag tag) {
        this.tags.add(tag);
    }

    public DescriptorTag getTagByName(String name) {
        for (int i = 0; i < this.tags.size(); ++i) {
            DescriptorTag tag = (DescriptorTag)this.tags.get(i);
            if (!tag.getTagName().equals(name)) continue;
            return tag;
        }
        return this.parent != null ? this.parent.getTagByName(name) : null;
    }

    public Collection getAllTags() {
        ArrayList items = new ArrayList(this.tags);
        if (this.parent != null) {
            items.addAll(this.parent.getAllTags());
        }
        return items;
    }

    public Element element(String arg0) {
        DescriptorTag tag = this.getTagByName(arg0);
        if (tag != null) {
            try {
                return tag.create();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.element(arg0);
    }

    public Element element(String name, Namespace namespace) {
        DescriptorTag tag = this.getTagByName(name);
        if (tag != null) {
            try {
                DescriptorElement element = tag.create();
                return element;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return super.element(name, namespace);
    }

    public Document document(Element rootElement) {
        if (this.descriptorClass != null) {
            try {
                Constructor constructor = this.descriptorClass.getConstructor(Element.class, DescriptorType.class);
                Document doc = (Document)constructor.newInstance(rootElement, this);
                return doc;
            }
            catch (Exception ex) {
                throw new CargoException("Error constructing document type", ex);
            }
        }
        return new Document(rootElement);
    }

    public JDOMFactory getJDOMFactory() {
        return this;
    }
}

