/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogicConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogicCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.weblogic.WebLogicLocalContainer;
import org.codehaus.cargo.container.weblogic.internal.WebLogicStandaloneLocalConfigurationCapability;

public class WebLogicStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration
implements WebLogicConfiguration {
    private static ConfigurationCapability capability = new WebLogicStandaloneLocalConfigurationCapability();

    public WebLogicStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createWebLogicFilterChain();
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/config.xml", new File(this.getHome(), "config.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/DefaultAuthenticatorInit.ldift", new File(this.getHome(), "DefaultAuthenticatorInit.ldift"), filterChain);
        this.setupDeployables((WebLogicLocalContainer)container);
    }

    private FilterChain createWebLogicFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        StringBuffer appTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() != DeployableType.WAR || !((WAR)deployable).isExpandedWar()) continue;
            String context = ((WAR)deployable).getContext();
            appTokenValue.append("<Application ");
            appTokenValue.append("Name=\"_" + context + "_app\" ");
            appTokenValue.append("Path=\"" + this.getFileHandler().getParent(deployable.getFile()) + "\" ");
            appTokenValue.append("StagedTargets=\"server\" StagingMode=\"stage\" TwoPhase=\"true\"");
            appTokenValue.append(">");
            appTokenValue.append("<WebAppComponent ");
            appTokenValue.append("Name=\"" + context + "\" ");
            appTokenValue.append("Targets=\"server\" ");
            appTokenValue.append("URI=\"" + context + "\"");
            appTokenValue.append("/></Application>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "weblogic.apps", appTokenValue.toString());
        return filterChain;
    }

    protected void setupDeployables(WebLogicLocalContainer container) throws IOException {
        WebLogicLocalContainer weblogicContainer = container;
        File deployDir = new File(this.getDomainHome(), weblogicContainer.getAutoDeployDirectory());
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        WebLogicCopyingInstalledLocalDeployer deployer = new WebLogicCopyingInstalledLocalDeployer((InstalledLocalContainer)((Object)container));
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
    }

    public String toString() {
        return "WebLogic Standalone Configuration";
    }

    public String getDomainHome() {
        return this.getHome();
    }
}

