/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatStandaloneLocalConfiguration;

public abstract class AbstractCatalinaStandaloneLocalConfiguration
extends AbstractTomcatStandaloneLocalConfiguration {
    public AbstractCatalinaStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager");
        this.setProperty("cargo.rmi.port", "8205");
        this.setProperty("cargo.servlet.uriencoding", "ISO-8859-1");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createTomcatFilterChain();
        this.getFileHandler().createDirectory(this.getHome(), "temp");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server.xml", new File(confDir, "server.xml"), filterChain);
        if (container instanceof InstalledLocalContainer) {
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] sharedClassPath = installedContainer.getSharedClasspath();
            StringBuffer tmp = new StringBuffer();
            if (sharedClassPath != null) {
                for (int i = 0; i < sharedClassPath.length; ++i) {
                    tmp.append(',').append(sharedClassPath[i]);
                }
            }
            this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.common.loader", tmp.toString());
        }
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/catalina.properties", new File(confDir, "catalina.properties"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/tomcat-users.xml", new File(confDir, "tomcat-users.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/web.xml", new File(confDir, "web.xml"));
        this.setupManager(container);
        this.setupWebApps(container);
    }

    protected abstract void setupManager(LocalContainer var1);

    private void setupWebApps(LocalContainer container) {
        try {
            if (container instanceof EmbeddedLocalContainer) {
                Tomcat5xEmbeddedLocalDeployer deployer = new Tomcat5xEmbeddedLocalDeployer((Tomcat5xEmbeddedLocalContainer)container);
                deployer.deploy(this.getDeployables());
            } else {
                String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
                TomcatCopyingInstalledLocalDeployer deployer = new TomcatCopyingInstalledLocalDeployer((InstalledLocalContainer)container);
                deployer.setShouldDeployExpandedWARs(true);
                deployer.setShouldCopyWars(false);
                deployer.deploy(this.getDeployables());
                this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", e);
        }
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "1" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "2" : "4");
        return level;
    }

    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.secure", String.valueOf("https".equalsIgnoreCase(this.getPropertyValue("cargo.protocol"))));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.servlet.uriencoding", this.getPropertyValue("cargo.servlet.uriencoding"));
        StringBuffer webappTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            TomcatWAR tomcatWar;
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() != DeployableType.WAR) {
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            if (deployable instanceof TomcatWAR && (tomcatWar = (TomcatWAR)deployable).containsContextFile()) continue;
            webappTokenValue.append(this.createContextToken((WAR)deployable));
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        return filterChain;
    }

    protected abstract String createDatasourceTokenValue();

    protected abstract String createResourceTokenValue();

    protected String createContextToken(WAR deployable) {
        StringBuffer contextTokenValue = new StringBuffer();
        contextTokenValue.append("<Context path=\"");
        contextTokenValue.append("/" + deployable.getContext());
        contextTokenValue.append("\" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\">");
        contextTokenValue.append("\n" + this.createDatasourceTokenValue() + "\n");
        contextTokenValue.append("\n" + this.createResourceTokenValue() + "\n");
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }

    public String toString() {
        return "Catalina Standalone Configuration";
    }
}

