/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.spi.deployer.AbstractLocalDeployer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.internal.Tomcat5xEmbedded;
import org.codehaus.cargo.module.webapp.tomcat.TomcatWarArchive;
import org.jdom.Attribute;

public class Tomcat5xEmbeddedLocalDeployer
extends AbstractLocalDeployer {
    private final Tomcat5xEmbeddedLocalContainer container;
    private final Map deployed = new HashMap();

    public Tomcat5xEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super(container);
        this.container = (Tomcat5xEmbeddedLocalContainer)container;
    }

    public void deploy(Deployable deployable) {
        String docBase;
        if (this.container.getController() == null) {
            this.container.scheduleDeployment(deployable);
            return;
        }
        WAR war = (WAR)deployable;
        if (!war.isExpandedWar()) {
            String home = this.container.getConfiguration().getHome();
            try {
                docBase = this.getFileHandler().append(home, "webapps/" + war.getContext());
                this.explode(war.getFile(), docBase);
            }
            catch (IOException e) {
                throw new ContainerException("Failed to expand " + war.getFile(), e);
            }
        } else {
            docBase = war.getFile();
        }
        Tomcat5xEmbedded.Context context = this.container.getController().createContext('/' + war.getContext(), docBase);
        try {
            TomcatWarArchive twar = new TomcatWarArchive(docBase);
            if (twar.getTomcatContextXml() != null) {
                Map params = twar.getTomcatContextXml().getParameters();
                Iterator itr = params.entrySet().iterator();
                while (itr.hasNext()) {
                    String value;
                    String key;
                    Map.Entry param = itr.next();
                    if (param.getKey() instanceof Attribute) {
                        key = ((Attribute)param.getKey()).getValue();
                    } else if (param.getKey() instanceof String) {
                        key = (String)param.getKey();
                    } else {
                        throw new ContainerException("Cannot handle Parameter Type : " + param.getKey().getClass().toString());
                    }
                    if (param.getValue() instanceof Attribute) {
                        value = ((Attribute)param.getValue()).getValue();
                    } else if (param.getValue() instanceof String) {
                        value = (String)param.getValue();
                    } else {
                        throw new ContainerException("Cannot handle Parameter Type : " + param.getValue().getClass().toString());
                    }
                    context.addParameter(key, value);
                }
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to parse Tomcat WAR file in [" + docBase + "]", e);
        }
        this.container.getHost().addChild(context);
        this.deployed.put(deployable, context);
    }

    public void undeploy(Deployable deployable) {
        Tomcat5xEmbedded.Context context = this.getExistingContext(deployable);
        this.container.getHost().removeChild(context);
        this.deployed.remove(deployable);
    }

    public void redeploy(Deployable deployable) {
        Tomcat5xEmbedded.Context context = this.getExistingContext(deployable);
        context.reload();
    }

    public void start(Deployable deployable) {
        this.getExistingContext(deployable).setAvailable(true);
    }

    public void stop(Deployable deployable) {
        this.getExistingContext(deployable).setAvailable(false);
    }

    public DeployerType getType() {
        return DeployerType.EMBEDDED;
    }

    private Tomcat5xEmbedded.Context getExistingContext(Deployable deployable) {
        Tomcat5xEmbedded.Context context = (Tomcat5xEmbedded.Context)this.deployed.get(deployable);
        if (context == null) {
            throw new ContainerException("Not deployed yet: " + deployable);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explode(String war, String exploded) throws IOException {
        if (this.getFileHandler().exists(exploded)) {
            this.getFileHandler().delete(exploded);
        }
        byte[] buf = new byte[1024];
        JarFile archive = new JarFile(new File(war).getAbsoluteFile());
        Enumeration<JarEntry> e = archive.entries();
        while (e.hasMoreElements()) {
            JarEntry j = e.nextElement();
            String dst = this.getFileHandler().append(exploded, j.getName());
            if (j.isDirectory()) {
                this.getFileHandler().mkdirs(dst);
                continue;
            }
            this.getFileHandler().mkdirs(this.getFileHandler().getParent(dst));
            InputStream in = archive.getInputStream(j);
            FileOutputStream out = new FileOutputStream(dst);
            try {
                int sz;
                while ((sz = in.read(buf)) >= 0) {
                    out.write(buf, 0, sz);
                }
            }
            finally {
                in.close();
                out.close();
            }
        }
        archive.close();
    }
}

