/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.property.DataSource;
import org.codehaus.cargo.container.resource.Resource;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;

public class Tomcat4xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    public Tomcat4xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected void setupManager(LocalContainer container) {
        Copy copy = (Copy)this.getAntUtils().createAntTask("copy");
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(((InstalledLocalContainer)container).getHome()));
        fileSet.createInclude().setName("server/lib/catalina.jar");
        fileSet.createInclude().setName("server/webapps/manager/**");
        fileSet.createInclude().setName("webapps/manager.xml");
        copy.addFileset(fileSet);
        copy.setTodir(new File(this.getHome()));
        copy.execute();
    }

    protected String createDatasourceTokenValue() {
        this.getLogger().debug("Tomcat 4x createDatasourceTokenValue", this.getClass().getName());
        String dataSourceProperty = this.getPropertyValue("cargo.datasource.datasource");
        this.getLogger().debug("Datasource property value [" + dataSourceProperty + "]", this.getClass().getName());
        if (dataSourceProperty == null) {
            return " ";
        }
        DataSource ds = new DataSource(dataSourceProperty);
        return "  <Resource name='" + ds.getJndiLocation() + "' auth='Container' " + "type='" + ds.getDataSourceType() + "'/>\n" + "  <ResourceParams name='" + ds.getJndiLocation() + "'>\n" + "    <parameter>\n" + "      <name>driverClassName</name>\n" + "      <value>" + ds.getDriverClass() + "</value>\n" + "    </parameter>\n" + "    <parameter>\n" + "      <name>url</name>\n" + "      <value>" + ds.getUrl() + "</value>\n" + "    </parameter>\n" + "    <parameter>\n" + "      <name>username</name>\n" + "      <value>" + ds.getUsername() + "</value>\n" + "    </parameter>\n" + "    <parameter>\n" + "      <name>password</name>\n" + "      <value>" + ds.getPassword() + "</value>\n" + "    </parameter>\n" + "    <parameter>\n" + "      <name>factory</name>\n" + "      <value>org.apache.commons.dbcp.BasicDataSourceFactory</value>\n" + "    </parameter>\n" + "  </ResourceParams>\n" + "  <Resource name='UserTransaction' " + "type='javax.transaction.UserTransaction' auth='Container'>\n" + "  </Resource>\n" + "  <ResourceParams name='UserTransaction'>\n" + "    <parameter>\n" + "      <name>factory</name>\n" + "      <value>org.objectweb.jotm.UserTransactionFactory</value>\n" + "    </parameter>\n" + "    <parameter>\n" + "      <name>jotm.timeout</name>\n" + "      <value>60</value>\n" + "    </parameter>\n" + "</ResourceParams>";
    }

    protected String createResourceTokenValue() {
        String out = "";
        Iterator it = this.getResources().iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            out = out + "<Resource name=\"" + r.getName() + "\"\n" + "          type=\"" + r.getType() + "\"\n" + "          auth=\"Container\"\n" + "/>\n";
            Set parameterNames = r.getParameterNames();
            if (parameterNames.size() <= 0) continue;
            out = out + "<ResourceParams name=\"" + r.getName() + "\">\n";
            Iterator pit = parameterNames.iterator();
            while (pit.hasNext()) {
                String paramName = (String)pit.next();
                out = out + "  <parameter>\n" + "    <name>" + paramName + "</name>\n" + "    <value>" + r.getParameter(paramName) + "</value>\n" + "  </parameter>\n";
            }
            out = out + "</ResourceParams>\n";
        }
        return out;
    }

    public String toString() {
        return "Tomcat 4.x Standalone Configuration";
    }
}

