/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;

public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    private Map configfiles;
    private FilterChain filterChain;

    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", "medium");
        this.configfiles = new HashMap();
    }

    public void configure(LocalContainer container) {
        super.configure(container);
        this.configureFiles(this.getFilterChain());
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        if (!(this.getFileHandler().exists(timestampFile) || this.getFileHandler().exists(this.getHome()) && this.getFileHandler().isDirectoryEmpty(this.getHome()) || !this.getFileHandler().exists(this.getHome()))) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. " + "When using standalone configurations, the configuration dir must point to an " + "empty directory. Note that everything in that dir will get deleted by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    protected final FilterChain createFilterChain() {
        this.filterChain = new FilterChain();
        this.getAntUtils().addTokensToFilterChain(this.filterChain, this.getProperties());
        return this.filterChain;
    }

    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        if (!(level.equalsIgnoreCase("low") || level.equalsIgnoreCase("medium") || level.equalsIgnoreCase("high"))) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }

    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    public FilterChain getFilterChain() {
        if (this.filterChain == null) {
            this.filterChain = this.createFilterChain();
        }
        return this.filterChain;
    }

    public void setFileProperty(String file, String tofile, String todir) {
        String filename;
        String fileName = file;
        String finalFile = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (tofile == null && todir != null) {
            filename = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            finalFile = this.getHome() + "/" + todir + "/" + filename;
        } else if (tofile != null && todir == null) {
            finalFile = this.getHome() + "/" + tofile;
        } else if (tofile == null && todir == null) {
            filename = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            finalFile = this.getHome() + "/" + filename;
        } else if (tofile != null && todir != null) {
            finalFile = this.getHome() + "/" + todir + "/" + tofile;
        }
        while (finalFile.indexOf("//") >= 0) {
            finalFile = finalFile.replaceAll("//", "/");
        }
        while (fileName.indexOf("//") >= 0) {
            fileName = fileName.replaceAll("//", "/");
        }
        this.configfiles.put(finalFile, fileName);
    }

    public String getFileProperty(String tofile) {
        return (String)this.configfiles.get(tofile);
    }

    public Map getFileProperties() {
        return this.configfiles;
    }

    protected void configureFiles(FilterChain filterChain) {
        Map files = this.getFileProperties();
        Iterator filesIt = files.keySet().iterator();
        while (filesIt.hasNext()) {
            String toFile = (String)filesIt.next();
            String fromFile = (String)files.get(toFile);
            this.getFileHandler().copyFile(fromFile, toFile, filterChain);
        }
    }
}

