/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.property.DataSource;
import org.codehaus.cargo.container.resin.internal.AbstractResinStandaloneLocalConfiguration;

public class Resin3xStandaloneLocalConfiguration
extends AbstractResinStandaloneLocalConfiguration {
    public Resin3xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected void prepareAdditions(Container container, FilterChain theFilterChain) throws IOException {
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/app-default.xml", new File(this.getHome(), "app-default.xml"), theFilterChain);
    }

    private String getResinLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "severe" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "warning" : "config");
        return level;
    }

    protected FilterChain createResinFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin.expanded.webapps", this.createExpandedWarTokenValue("document-directory"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.datasource.datasource", this.createDatasourceTokenValue());
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin3x.users", this.getSecurityToken("<user>", "</user>"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin3x.logging.level", this.getResinLoggingLevel(this.getPropertyValue("cargo.logging")));
        return filterChain;
    }

    protected String createDatasourceTokenValue() {
        String dataSourceProperty = this.getPropertyValue("cargo.datasource.datasource");
        this.getLogger().info("Datasource property value [" + dataSourceProperty + "]", this.getClass().getName());
        if (dataSourceProperty == null) {
            return " ";
        }
        DataSource ds = new DataSource(dataSourceProperty);
        return "<database jndi-name='" + ds.getJndiLocation() + "'>\n" + "  <driver type=\"" + ds.getDriverClass() + "\">\n" + "    <url>" + ds.getUrl() + "</url>\n" + "    <user>" + ds.getUsername() + "</user>\n" + "    <password>" + ds.getPassword() + "</password>\n" + "  </driver>\n" + "</database>";
    }
}

