/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.IOException;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.property.DataSource;
import org.codehaus.cargo.container.resin.internal.AbstractResinStandaloneLocalConfiguration;

public class Resin2xStandaloneLocalConfiguration
extends AbstractResinStandaloneLocalConfiguration {
    public Resin2xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected void prepareAdditions(Container container, FilterChain theFilterChain) throws IOException {
    }

    protected FilterChain createResinFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin.expanded.webapps", this.createExpandedWarTokenValue("app-dir"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.datasource.datasource", this.createDatasourceTokenValue());
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin2x.users", this.getSecurityToken("<init-param user='", "'/>"));
        String tokenValue = " ";
        String logLevel = this.getPropertyValue("cargo.logging");
        if (logLevel.equalsIgnoreCase("high")) {
            tokenValue = "<log id='/' href='stdout:' timestamp='[%H:%M:%S.%s]'/>";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "resin2x.debuglog", tokenValue);
        return filterChain;
    }

    protected String createDatasourceTokenValue() {
        String dataSourceProperty = this.getPropertyValue("cargo.datasource.datasource");
        if (dataSourceProperty == null) {
            return " ";
        }
        DataSource ds = new DataSource(dataSourceProperty);
        return "<resource-ref>\n      <res-ref-name>" + ds.getJndiLocation() + "</res-ref-name>\n" + "      <res-type>" + ds.getDataSourceType() + "</res-type>\n" + "      <init-param driver-name=\"" + ds.getDriverClass() + "\"/>\n" + "      <init-param url=\"" + ds.getUrl() + "\"/>\n" + "      <init-param user=\"" + ds.getUsername() + "\"/>\n" + "      <init-param password=\"" + ds.getPassword() + "\"/>\n" + "</resource-ref>";
    }
}

