/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.JettyExecutorThread;
import org.codehaus.cargo.container.property.User;

public class Jetty7xEmbeddedLocalContainer
extends AbstractJettyEmbeddedLocalContainer {
    public static final String ID = "jetty7x";
    private Object defaultRealm;
    private Object contextHandlers;
    private Class handlerClass;
    private Object handlers;
    private Method addHandlerMethod;
    private Method removeHandlerMethod;
    static /* synthetic */ Class class$java$lang$Object;

    public Jetty7xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Jetty 7.x Embedded";
    }

    public void setDefaultRealm(Object webapp) throws Exception {
        Class<?> userRealmClass = this.getClassLoader().loadClass("org.mortbay.jetty.security.UserRealm");
        if (this.defaultRealm != null) {
            Object securityHandler = webapp.getClass().getMethod("getSecurityHandler", new Class[0]).invoke(webapp, new Object[0]);
            securityHandler.getClass().getMethod("setUserRealm", userRealmClass).invoke(securityHandler, this.defaultRealm);
        }
    }

    protected void doStart() throws Exception {
        this.createServerObject();
        Class<?> selectConnectorClass = this.getClassLoader().loadClass("org.mortbay.jetty.nio.SelectChannelConnector");
        Object connector = selectConnectorClass.newInstance();
        selectConnectorClass.getMethod("setPort", Integer.TYPE).invoke(connector, new Integer(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        Class<?> connectorClass = this.getClassLoader().loadClass("org.mortbay.jetty.Connector");
        Object connectorArray = Array.newInstance(connectorClass, 1);
        Array.set(connectorArray, 0, connector);
        this.getServer().getClass().getMethod("addConnector", connectorClass).invoke(this.getServer(), connector);
        this.setSecurityRealm();
        this.handlerClass = this.getClassLoader().loadClass("org.mortbay.jetty.Handler");
        this.handlers = this.getClassLoader().loadClass("org.mortbay.jetty.handler.HandlerCollection").newInstance();
        this.contextHandlers = this.getClassLoader().loadClass("org.mortbay.jetty.handler.ContextHandlerCollection").newInstance();
        Object defaultHandler = this.getClassLoader().loadClass("org.mortbay.jetty.handler.DefaultHandler").newInstance();
        Object handlerArray = Array.newInstance(this.handlerClass, 2);
        Array.set(handlerArray, 0, this.contextHandlers);
        Array.set(handlerArray, 1, defaultHandler);
        this.handlers.getClass().getMethod("setHandlers", handlerArray.getClass()).invoke(this.handlers, handlerArray);
        this.getServer().getClass().getMethod("setHandler", this.handlerClass).invoke(this.getServer(), this.handlers);
        this.addHandlerMethod = this.contextHandlers.getClass().getMethod("addHandler", this.handlerClass);
        this.removeHandlerMethod = this.contextHandlers.getClass().getMethod("removeHandler", this.handlerClass);
        Iterator it = this.getConfiguration().getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() == DeployableType.WAR) {
                this.addHandler(this.createHandler(deployable));
                continue;
            }
            throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
        }
        this.addHandler(this.createHandler("/cargocpc", new File(this.getConfiguration().getHome(), "cargocpc.war").getPath()));
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), true);
        jettyRunner.setLogger(this.getLogger());
        jettyRunner.start();
    }

    public Object createHandler(Deployable deployable) throws Exception {
        Object handler = this.getClassLoader().loadClass("org.mortbay.jetty.webapp.WebAppContext").newInstance();
        handler.getClass().getMethod("setContextPath", String.class).invoke(handler, "/" + ((WAR)deployable).getContext());
        handler.getClass().getMethod("setWar", String.class).invoke(handler, deployable.getFile());
        this.setDefaultRealm(handler);
        return handler;
    }

    public Object createHandler(String contextPath, String war) throws Exception {
        Object handler = this.getClassLoader().loadClass("org.mortbay.jetty.webapp.WebAppContext").newInstance();
        handler.getClass().getMethod("setContextPath", String.class).invoke(handler, contextPath);
        handler.getClass().getMethod("setWar", String.class).invoke(handler, war);
        this.setDefaultRealm(handler);
        return handler;
    }

    public void addHandler(Object handler) throws Exception {
        if (this.addHandlerMethod == null) {
            throw new ContainerException("No Jetty instance to deploy to");
        }
        this.addHandlerMethod.invoke(this.contextHandlers, handler);
        Method m = this.getServer().getClass().getMethod("isStarted", new Class[0]);
        if (((Boolean)m.invoke(this.getServer(), null)).booleanValue()) {
            this.handlerClass.getMethod("start", new Class[0]).invoke(handler, null);
        }
    }

    public void removeHandler(Object handler) throws Exception {
        if (handler == null) {
            return;
        }
        if (this.removeHandlerMethod == null) {
            throw new ContainerException("No Jetty instance to deploy to");
        }
        this.removeHandlerMethod.invoke(this.contextHandlers, handler);
    }

    private void setSecurityRealm() throws Exception {
        if (this.getConfiguration().getPropertyValue("cargo.servlet.users") != null) {
            Class<?> realmClass = this.getClassLoader().loadClass("org.mortbay.jetty.security.HashUserRealm");
            this.defaultRealm = realmClass.getConstructor(String.class).newInstance("Cargo Test Realm");
            Iterator users = User.parseUsers(this.getConfiguration().getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                this.defaultRealm.getClass().getMethod("put", class$java$lang$Object == null ? Jetty7xEmbeddedLocalContainer.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Object == null ? Jetty7xEmbeddedLocalContainer.class$("java.lang.Object") : class$java$lang$Object).invoke(this.defaultRealm, user.getName(), user.getPassword());
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    this.defaultRealm.getClass().getMethod("addUserToRole", class$java$lang$String == null ? Jetty7xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? Jetty7xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String).invoke(this.defaultRealm, user.getName(), role);
                }
            }
            Object userRealmsArray = Array.newInstance(this.getClassLoader().loadClass("org.mortbay.jetty.security.UserRealm"), 1);
            Array.set(userRealmsArray, 0, this.defaultRealm);
            this.getServer().getClass().getMethod("setUserRealms", userRealmsArray.getClass()).invoke(this.getServer(), userRealmsArray);
            Object[] realmlist = (Object[])this.getServer().getClass().getMethod("getUserRealms", new Class[0]).invoke(this.getServer(), new Object[0]);
            this.getLogger().info("Added " + (realmlist == null ? "0" : String.valueOf(realmlist.length)) + " realms ", this.getClass().getName());
        }
    }

    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            super.createServerObject();
            this.server.getClass().getMethod("setStopAtShutdown", Boolean.TYPE).invoke(this.server, Boolean.TRUE);
        }
    }
}

