/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.Jetty5xEmbeddedStandaloneLocalConfigurationCapability;

public class Jetty5xEmbeddedStandaloneLocalConfiguration
extends AbstractJettyStandaloneLocalConfiguration {
    private static final Class[] EMPTY_CLASS_LIST = new Class[0];
    private static final Object[] EMPTY_ARGS_LIST = new Object[0];
    private static Jetty5xEmbeddedStandaloneLocalConfigurationCapability capability = new Jetty5xEmbeddedStandaloneLocalConfigurationCapability();

    public Jetty5xEmbeddedStandaloneLocalConfiguration(String dir) {
        super(dir);
        System.setProperty("org.mortbay.log.LogFactory.noDiscovery", "true");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void activateLogging(LocalContainer container) throws Exception {
        ClassLoader cl = ((EmbeddedLocalContainer)container).getClassLoader();
        Class<?> logFactoryClass = cl.loadClass("org.mortbay.log.LogFactory");
        Class<?> outputStreamLogSinkClass = cl.loadClass("org.mortbay.log.OutputStreamLogSink");
        Class<?> sinkClass = cl.loadClass("org.mortbay.log.LogSink");
        Object logFactory = logFactoryClass.getMethod("getFactory", EMPTY_CLASS_LIST).invoke(null, null);
        if (container.getOutput() != null) {
            Object logInstance = logFactory.getClass().getMethod("getInstance", String.class).invoke(logFactory, new Object[]{null});
            logInstance.getClass().getMethod("reset", EMPTY_CLASS_LIST).invoke(logInstance, EMPTY_ARGS_LIST);
            Object sink = outputStreamLogSinkClass.getConstructor(String.class).newInstance(container.getOutput());
            logInstance.getClass().getMethod("add", sinkClass).invoke(logInstance, sink);
            outputStreamLogSinkClass.getMethod("setAppend", Boolean.TYPE).invoke(sink, container.isAppend());
        } else {
            this.getLogger().info("Logging for Jetty container deferred to JCL discovery mechanism", Jetty5xEmbeddedStandaloneLocalConfiguration.class.getName());
        }
    }

    public String toString() {
        return "Jetty 5.x Embedded Standalone Configuration";
    }
}

