/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.internal.JBossInstalledLocalContainer;
import org.codehaus.cargo.container.jboss.internal.JBossStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public class JBossStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new JBossStandaloneLocalConfigurationCapability();
    protected JBossInstalledLocalContainer jbossContainer;

    public JBossStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1299");
        this.setProperty("cargo.jboss.configuration", "default");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public JBossInstalledLocalContainer getJbossContainer() {
        return this.jbossContainer;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.getLogger().info("Configuring JBoss using the [" + this.getPropertyValue("cargo.jboss.configuration") + "] server configuration", this.getClass().getName());
        this.setupConfigurationDir();
        this.jbossContainer = (JBossInstalledLocalContainer)container;
        FilterChain filterChain = this.createJBossFilterChain(this.jbossContainer);
        JBossInstalledLocalDeployer deployer = new JBossInstalledLocalDeployer(this.jbossContainer);
        deployer.deploy(this.getDeployables());
        if (container instanceof InstalledLocalContainer) {
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] sharedClassPath = installedContainer.getSharedClasspath();
            StringBuffer tmp = new StringBuffer();
            if (sharedClassPath != null) {
                for (int i = 0; i < sharedClassPath.length; ++i) {
                    String fileName = this.getFileHandler().getName(sharedClassPath[i]);
                    String directoryName = this.getFileHandler().getParent(sharedClassPath[i]);
                    tmp.append("<classpath codebase=\"" + directoryName + "\" archives=\"" + fileName + "\"/>");
                    tmp.append("\n");
                }
            }
            String sharedClassPathString = tmp.toString();
            this.getLogger().debug("Shared loader classpath is " + sharedClassPathString, this.getClass().getName());
            this.getAntUtils().addTokenToFilterChain(filterChain, "jboss.shared.classpath", tmp.toString());
        }
        String deployDir = this.getFileHandler().createDirectory(this.getHome(), "/deploy");
        String libDir = this.getFileHandler().createDirectory(this.getHome(), "/lib");
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "/conf");
        String clustered = this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered")).booleanValue()) {
            String farmDir = this.getFileHandler().createDirectory(this.getHome(), "/farm");
        }
        String[] cargoFiles = new String[]{"cargo-binding.xml", "log4j.xml", "jboss-service.xml"};
        for (int i = 0; i < cargoFiles.length; ++i) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + cargoFiles[i], new File(confDir, cargoFiles[i]), filterChain);
        }
        this.copyExternalResources(new File(this.jbossContainer.getConfDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(confDir), cargoFiles);
        this.copyExternalResources(new File(this.jbossContainer.getDeployDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(deployDir), new String[0]);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome(), "/deploy/cargocpc.war"));
    }

    public void verify() {
        super.verify();
        String configurationName = this.getPropertyValue("cargo.jboss.configuration");
        if (configurationName == null || configurationName.length() == 0) {
            throw new ContainerException("Invalid JBoss configuration: [cargo.jboss.configuration] doesn't exist.");
        }
    }

    protected void copyExternalResources(File sourceDir, File destDir, String[] cargoFiles) throws IOException {
        File[] sourceFiles = sourceDir.listFiles();
        if (sourceFiles != null) {
            for (int i = 0; i < sourceFiles.length; ++i) {
                if (this.isExcluded(cargoFiles, sourceFiles[i].getName())) continue;
                if (sourceFiles[i].isDirectory()) {
                    this.getFileHandler().createDirectory(destDir.getPath(), sourceFiles[i].getName());
                    this.copyExternalResources(sourceFiles[i], new File(destDir, sourceFiles[i].getName()), cargoFiles);
                    continue;
                }
                FileOutputStream fops = new FileOutputStream(new File(destDir, sourceFiles[i].getName()));
                this.getFileHandler().copy(new FileInputStream(sourceFiles[i]), fops);
                fops.close();
            }
        }
    }

    private boolean isExcluded(String[] cargoFiles, String filename) {
        for (int i = 0; i < cargoFiles.length; ++i) {
            if (!cargoFiles[i].equals(filename)) continue;
            return true;
        }
        return false;
    }

    protected FilterChain createJBossFilterChain(JBossInstalledLocalContainer container) throws MalformedURLException {
        FilterChain filterChain = this.createFilterChain();
        String[] version = this.jbossContainer.getName().split(" ");
        String mayorVersion = version[1].substring(0, 1);
        String minorVersion = version[1].substring(2, 3);
        String revisionVersion = version[1].substring(4, 5);
        if (Integer.valueOf(mayorVersion) > 3 || Integer.valueOf(minorVersion) > 2 || Integer.valueOf(revisionVersion) > 7) {
            this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.server.mode.attr", "<attribute name=\"ServerMode\">true</attribute>");
        }
        String bindingXmlFile = this.getFileHandler().append(this.getHome(), "conf/cargo-binding.xml");
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.binding.url", this.getFileHandler().getURL(bindingXmlFile));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.logging", this.getJBossLogLevel(this.getPropertyValue("cargo.logging")));
        File libDir = new File(container.getLibDir(this.getPropertyValue("cargo.jboss.configuration")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.server.lib.url", libDir.toURL().toString());
        StringBuffer buffer = new StringBuffer();
        File deployDir = new File(container.getDeployDir(this.getPropertyValue("cargo.jboss.configuration")));
        buffer.append("deploy/, ").append(deployDir.toURL().toString());
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.server.deploy.url", "deploy/");
        return filterChain;
    }

    private String getJBossLogLevel(String cargoLogLevel) {
        String level = cargoLogLevel.equalsIgnoreCase("low") ? "ERROR" : (cargoLogLevel.equalsIgnoreCase("medium") ? "WARN" : "INFO");
        return level;
    }

    public String toString() {
        return "JBoss Standalone Configuration";
    }
}

