/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo.internal;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GeronimoUtils {
    public ClassLoader createGeronimoURLClassloader(File geronimoHomeDir) {
        File libDir = new File(geronimoHomeDir, "lib");
        File[] files = libDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getPath().endsWith(".jar");
            }
        });
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = files[i].toURL();
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return new URLClassLoader(urls);
    }

    public boolean isGeronimoStarted(String host, String rmiPort, String username, String password) {
        boolean isStarted = false;
        try {
            isStarted = this.isKernelFullyStarted(host, rmiPort, username, password);
        }
        catch (Exception e) {
            // empty catch block
        }
        return isStarted;
    }

    private boolean isKernelFullyStarted(String host, String rmiPort, String username, String password) throws Exception {
        Object kernel = this.getKernel(host, rmiPort, username, password);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (this.isKernelAlive(kernel)) {
            Class<?> gbeanQueryClass = cl.loadClass("org.apache.geronimo.gbean.GBeanQuery");
            Object gbeanQuery = gbeanQueryClass.getConstructor(String.class, String.class).newInstance(null, cl.loadClass("org.apache.geronimo.kernel.config.PersistentConfigurationList").getName());
            Set configLists = (Set)kernel.getClass().getMethod("listGBeans", gbeanQueryClass).invoke(kernel, gbeanQuery);
            if (!configLists.isEmpty()) {
                Object on = configLists.toArray()[0];
                Boolean b = (Boolean)kernel.getClass().getMethod("getAttribute", cl.loadClass("javax.management.ObjectName"), String.class).invoke(kernel, on, "kernelFullyStarted");
                return b;
            }
        }
        return false;
    }

    private boolean isKernelAlive(Object kernel) throws Exception {
        Boolean running = (Boolean)kernel.getClass().getMethod("isRunning", null).invoke(kernel, null);
        return running;
    }

    private Object getKernel(String host, String rmiPort, String username, String password) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String jmxServiceURL = "service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + rmiPort + "/JMXConnector";
        Class<?> jmxServiceURLClass = cl.loadClass("javax.management.remote.JMXServiceURL");
        Object address = jmxServiceURLClass.getConstructor(String.class).newInstance(jmxServiceURL);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("jmx.remote.credentials", new String[]{username, password});
        Object jmxConnector = cl.loadClass("javax.management.remote.JMXConnectorFactory").getMethod("connect", jmxServiceURLClass, Map.class).invoke(null, address, map);
        Object mbServerConnection = jmxConnector.getClass().getMethod("getMBeanServerConnection", null).invoke(jmxConnector, null);
        return cl.loadClass("org.apache.geronimo.kernel.jmx.KernelDelegate").getConstructor(cl.loadClass("javax.management.MBeanServerConnection")).newInstance(mbServerConnection);
    }
}

