/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.runner;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.remote.internal.RemoteClient;
import org.junit.remote.internal.RemoteTestClass;
import org.junit.remote.internal.RemoteTestResult;
import org.junit.remote.internal.URLConnectionFactory;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class RemoteRunner
extends Runner
implements Filterable,
Sortable {
    private URLConnectionFactory connectionFactory;
    private RemoteTestClass testClass;
    private Description description;
    private Map<Description, String> methodNames = new HashMap<Description, String>();

    public RemoteRunner(Class clazz) {
        assert (clazz != null);
        this.testClass = new RemoteTestClass(clazz);
        this.description = Description.createSuiteDescription((String)this.testClass.getName(), (Annotation[])this.testClass.getAnnotations());
        for (Method method : this.testClass.findTestMethods()) {
            String methodName = method.getName();
            Description child = Description.createTestDescription((Class)clazz, (String)methodName, (Annotation[])method.getAnnotations());
            this.methodNames.put(child, methodName);
            this.description.addChild(child);
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        assert (filter != null);
        ArrayList children = this.description.getChildren();
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Description child = (Description)itr.next();
            if (filter.shouldRun(child)) continue;
            itr.remove();
            this.methodNames.remove(child);
        }
        if (children.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(Sorter sorter) {
        assert (sorter != null);
        Collections.sort(this.description.getChildren(), sorter);
    }

    public Description getDescription() {
        return this.description;
    }

    protected String getMethodName(Description description) {
        assert (description != null);
        return this.methodNames.get(description);
    }

    protected URLConnectionFactory getURLConnectionFactory() {
        return this.connectionFactory;
    }

    protected void setURLConnectionFactory(URLConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        assert (notifier != null);
        RemoteClient client = new RemoteClient(this.testClass, this.connectionFactory);
        try {
            client.setUpClass();
            for (Description child : this.description.getChildren()) {
                try {
                    notifier.fireTestStarted(child);
                    String methodName = this.getMethodName(child);
                    RemoteTestResult result = client.runMethod(methodName);
                    if (!result.failed()) continue;
                    throw result.getCause();
                }
                catch (Throwable t) {
                    notifier.fireTestFailure(new Failure(child, t));
                }
                finally {
                    notifier.fireTestFinished(child);
                }
            }
        }
        catch (Throwable t) {
            notifier.fireTestFailure(new Failure(this.description, t));
        }
        finally {
            try {
                client.tearDownClass();
            }
            catch (IOException e) {}
        }
    }
}

