/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.remote.internal.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    public static Class forName(String name) {
        assert (name != null);
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void invokeNoArgStaticMethods(Collection<Method> methods) throws IllegalAccessException, InvocationTargetException {
        Classes.invokeNoArgInstanceMethods(methods, null);
    }

    public static void invokeNoArgInstanceMethods(Collection<Method> methods, Object instance) throws IllegalAccessException, InvocationTargetException {
        assert (methods != null);
        for (Method method : methods) {
            Classes.invokeNoArgMethod(method, instance);
        }
    }

    public static void invokeNoArgMethod(Method method, Object instance) throws IllegalAccessException, InvocationTargetException {
        method.invoke(instance, new Object[0]);
    }

    public static boolean overrides(Method m1, Method m2) {
        assert (m1 != null);
        assert (m2 != null);
        return m1.getName().equals(m2.getName()) && m1.getReturnType().isAssignableFrom(m2.getReturnType()) && Arrays.isEqual(m1.getParameterTypes(), m2.getParameterTypes());
    }

    private Classes() {
    }
}

