/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.junit.remote.internal.util.MethodComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotations {
    public static boolean isAnnotated(Class clazz, Class<? extends Annotation> annotationClass) {
        assert (clazz != null);
        assert (annotationClass != null);
        return clazz.getAnnotation(annotationClass) != null;
    }

    public static boolean isAnnotated(Method method, Class<? extends Annotation> annotationClass) {
        assert (method != null);
        assert (annotationClass != null);
        return method.getAnnotation(annotationClass) != null;
    }

    public static <A extends Annotation> A getAnnotation(Class clazz, Class<A> annotationClass) {
        assert (clazz != null);
        assert (annotationClass != null);
        return clazz.getAnnotation(annotationClass);
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        return method.getAnnotation(annotationClass);
    }

    public static <A extends Annotation> A requireAnnotation(Class clazz, Class<A> annotationClass) {
        return Annotations.requireAnnotation(annotationClass, Annotations.getAnnotation(clazz, annotationClass));
    }

    public static <A extends Annotation> A requireAnnotation(Method method, Class<A> annotationClass) {
        return Annotations.requireAnnotation(annotationClass, Annotations.getAnnotation(method, annotationClass));
    }

    private static <A extends Annotation> A requireAnnotation(Class<A> annotationClass, A a) {
        if (a == null) {
            throw new IllegalArgumentException("Missing annotation: " + annotationClass);
        }
        return a;
    }

    public static Set<Method> findAnnotatedMethods(Class clazz, Class<? extends Annotation> annotationClass) {
        return Annotations.findAnnotatedMethods(clazz, annotationClass, MethodComparator.PARENT_LAST);
    }

    public static Set<Method> findAnnotatedMethods(Class clazz, Class<? extends Annotation> annotationClass, Comparator<Method> comparator) {
        return Annotations.findAnnotatedMethods(clazz, annotationClass, new TreeSet<Method>(comparator));
    }

    private static Set<Method> findAnnotatedMethods(Class clazz, Class<? extends Annotation> annotationClass, Set<Method> methods) {
        assert (clazz != null);
        assert (annotationClass != null);
        assert (methods != null);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Annotations.isAnnotated(method, annotationClass) || methods.contains(method)) continue;
            methods.add(method);
        }
        Class parent = clazz.getSuperclass();
        if (parent != null) {
            Annotations.findAnnotatedMethods(parent, annotationClass, methods);
        }
        return methods;
    }

    private Annotations() {
    }
}

