/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.junit.remote.internal.util.Strings;

public class RemoteUrl
implements Serializable {
    private static final String ENDPOINT_SEPARATOR = "/";
    private String endpoint;
    private String className;
    private String methodName;

    public static RemoteUrl forRequest(HttpServletRequest request) throws IOException {
        RemoteUrl url = new RemoteUrl(request.getServletPath());
        String s = request.getPathInfo();
        if (s == null || !s.startsWith(ENDPOINT_SEPARATOR)) {
            throw new MalformedURLException("Malformed request URL: " + request.getRequestURL());
        }
        url.setClassName(s.substring(1));
        url.setMethodName(request.getParameter("method"));
        return url;
    }

    public RemoteUrl(String endpoint) {
        this(endpoint, null, null);
    }

    public RemoteUrl(String endpoint, String className) {
        this(endpoint, className, null);
    }

    public RemoteUrl(String endpoint, String className, String methodName) {
        assert (endpoint != null);
        this.endpoint = endpoint;
        this.className = className;
        this.methodName = methodName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.endpoint);
        if (!this.endpoint.endsWith(ENDPOINT_SEPARATOR)) {
            sb.append(ENDPOINT_SEPARATOR);
        }
        if (!Strings.isEmpty(this.className)) {
            sb.append(this.className);
            if (!Strings.isEmpty(this.methodName)) {
                sb.append("?method=");
                sb.append(this.methodName);
            }
        }
        return sb.toString();
    }

    public URL toURL() throws IOException {
        return new URL(this.toString());
    }
}

