/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.junit.remote.internal.util.Strings;

public class RemoteTestResult
implements Serializable {
    public static final RemoteTestResult PASSED = new RemoteTestResult(true);
    private static final String MESSAGE_PASSED = "PASSED";
    private static final String MESSAGE_FAILED = "FAILED";
    private static final String MESSAGE_SEPARATOR = " ";
    private boolean passed;
    private Throwable cause;

    public static RemoteTestResult parse(String s) throws IOException {
        int ndx;
        assert (s != null);
        if (s.equals(MESSAGE_PASSED)) {
            return PASSED;
        }
        if (s.startsWith(MESSAGE_FAILED) && (ndx = MESSAGE_FAILED.length() + 1) <= s.length()) {
            return new RemoteTestResult(s.substring(ndx));
        }
        throw new IOException("Unable to parse result: " + s);
    }

    protected RemoteTestResult(boolean passed) {
        this.passed = passed;
    }

    public RemoteTestResult(Throwable cause) {
        this(false);
        this.cause = cause;
    }

    public RemoteTestResult(String message) {
        this((Throwable)((Object)new AssertionError((Object)message)));
    }

    public boolean passed() {
        return this.passed;
    }

    public boolean failed() {
        return !this.passed;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void writeTo(PrintWriter writer) {
        assert (writer != null);
        if (this.passed) {
            writer.write(MESSAGE_PASSED);
        } else {
            writer.write(MESSAGE_FAILED);
            writer.write(MESSAGE_SEPARATOR);
            String message = this.cause.getMessage();
            if (!Strings.isEmpty(message)) {
                writer.write(message);
            }
        }
    }
}

