/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.Test;
import org.junit.remote.RemoteException;
import org.junit.remote.internal.RemoteTestResult;
import org.junit.remote.internal.util.Annotations;
import org.junit.remote.internal.util.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestHelper {
    private Method method;
    private Test test;

    public RemoteTestHelper(Method method) {
        assert (method != null);
        this.method = method;
        this.test = Annotations.requireAnnotation(method, Test.class);
    }

    public Class<? extends Throwable> getExpected() {
        return this.test.expected();
    }

    public long getTimeout() {
        return this.test.timeout();
    }

    public RemoteTestResult invokeTestMethod(Object instance) throws RemoteException {
        assert (instance != null);
        Class<? extends Throwable> expected = this.getExpected();
        try {
            Classes.invokeNoArgMethod(this.method, instance);
            if (!"org.junit.Test$None".equals(expected.getName())) {
                return new RemoteTestResult("Expected: " + expected);
            }
            return RemoteTestResult.PASSED;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = e.getCause();
                if (cause instanceof AssertionError) {
                    return new RemoteTestResult(cause);
                }
                if (expected != null && expected.isAssignableFrom(cause.getClass())) {
                    return RemoteTestResult.PASSED;
                }
                throw new RemoteException(cause);
            }
            throw new RemoteException(e);
        }
    }
}

