/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.remote.RemoteException;
import org.junit.remote.annotation.Remote;
import org.junit.remote.internal.util.Annotations;
import org.junit.remote.internal.util.MethodComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestClass
implements Serializable {
    private Class clazz;
    private Remote remote;

    public RemoteTestClass(Class clazz) {
        assert (clazz != null);
        this.clazz = clazz;
        this.remote = (Remote)((Object)Annotations.requireAnnotation(clazz, Remote.class));
    }

    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getEndpoint() {
        return this.remote.endpoint();
    }

    public long getTimeout() {
        return this.remote.timeout();
    }

    public Set<Method> findBeforeClassMethods() {
        return Annotations.findAnnotatedMethods(this.clazz, BeforeClass.class, MethodComparator.PARENT_FIRST);
    }

    public Set<Method> findAfterClassMethods() {
        return Annotations.findAnnotatedMethods(this.clazz, AfterClass.class, MethodComparator.PARENT_LAST);
    }

    public Set<Method> findBeforeMethods() {
        return Annotations.findAnnotatedMethods(this.clazz, Before.class, MethodComparator.PARENT_FIRST);
    }

    public Set<Method> findAfterMethods() {
        return Annotations.findAnnotatedMethods(this.clazz, After.class, MethodComparator.PARENT_LAST);
    }

    public Set<Method> findTestMethods() {
        return Annotations.findAnnotatedMethods(this.clazz, Test.class);
    }

    public Object newInstance() throws RemoteException {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RemoteException(e);
        }
    }
}

