/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.remote.RemoteException;
import org.junit.remote.internal.RemoteTestClass;
import org.junit.remote.internal.RemoteTestHelper;
import org.junit.remote.internal.RemoteTestResult;
import org.junit.remote.internal.util.Classes;

public class RemoteExecutor
implements Serializable {
    private RemoteTestClass testClass;
    private Set<Method> beforeMethods;
    private Set<Method> afterMethods;
    private Map<String, Method> testMethods = new HashMap<String, Method>();

    public RemoteExecutor(String name) throws RemoteException {
        this(Classes.forName(name));
    }

    public RemoteExecutor(Class clazz) throws RemoteException {
        assert (clazz != null);
        this.testClass = new RemoteTestClass(clazz);
        this.beforeMethods = this.testClass.findBeforeMethods();
        this.afterMethods = this.testClass.findAfterMethods();
        for (Method method : this.testClass.findTestMethods()) {
            this.testMethods.put(method.getName(), method);
        }
    }

    protected void invokeBeforeClassMethods() throws RemoteException {
        try {
            Classes.invokeNoArgStaticMethods(this.testClass.findBeforeClassMethods());
        }
        catch (Exception e) {
            RemoteExecutor.handleException(e);
        }
    }

    protected void invokeAfterClassMethods() throws RemoteException {
        try {
            Classes.invokeNoArgStaticMethods(this.testClass.findAfterClassMethods());
        }
        catch (Exception e) {
            RemoteExecutor.handleException(e);
        }
    }

    protected void invokeBeforeMethods(Object instance) throws RemoteException {
        try {
            Classes.invokeNoArgInstanceMethods(this.beforeMethods, instance);
        }
        catch (Exception e) {
            RemoteExecutor.handleException(e);
        }
    }

    protected void invokeAfterMethods(Object instance) throws RemoteException {
        try {
            Classes.invokeNoArgInstanceMethods(this.afterMethods, instance);
        }
        catch (Exception e) {
            RemoteExecutor.handleException(e);
        }
    }

    public void setUpClass() throws RemoteException {
        this.invokeBeforeClassMethods();
    }

    public RemoteTestResult runMethod(String name) throws RemoteException {
        Method method = this.testMethods.get(name);
        if (method == null) {
            throw new RemoteException("Unable to find test method: " + name);
        }
        return this.runMethod(method, this.testClass.newInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteTestResult runMethod(Method method, Object instance) throws RemoteException {
        try {
            this.invokeBeforeMethods(instance);
            RemoteTestHelper helper = new RemoteTestHelper(method);
            RemoteTestResult remoteTestResult = helper.invokeTestMethod(instance);
            return remoteTestResult;
        }
        finally {
            this.invokeAfterMethods(instance);
        }
    }

    public void tearDownClass() throws RemoteException {
        this.invokeAfterClassMethods();
    }

    private static void handleException(Throwable t) throws RemoteException {
        Throwable cause;
        if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
            throw new RemoteException(cause);
        }
        throw new RemoteException(t);
    }
}

