/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.junit.remote.RemoteException;
import org.junit.remote.internal.HttpURLConnectionFactory;
import org.junit.remote.internal.RemoteTestClass;
import org.junit.remote.internal.RemoteTestResult;
import org.junit.remote.internal.RemoteUrl;
import org.junit.remote.internal.URLConnectionFactory;
import org.junit.remote.internal.util.Strings;

public class RemoteClient {
    private RemoteTestClass testClass;
    private URLConnectionFactory connectionFactory;

    public RemoteClient(RemoteTestClass testClass) {
        this(testClass, null);
    }

    public RemoteClient(RemoteTestClass testClass, URLConnectionFactory connectionFactory) {
        assert (testClass != null);
        this.testClass = testClass;
        if (connectionFactory == null) {
            connectionFactory = new HttpURLConnectionFactory();
        }
        this.connectionFactory = connectionFactory;
    }

    public URLConnectionFactory getURLConnectionFactory() {
        return this.connectionFactory;
    }

    public void setUpClass() throws IOException {
        this.sendPut(this.createRemoteUrl());
    }

    public void tearDownClass() throws IOException {
        this.sendDelete(this.createRemoteUrl());
    }

    public RemoteTestResult runMethod(String methodName) throws IOException {
        return RemoteTestResult.parse(this.sendPost(this.createRemoteUrl(methodName)));
    }

    private RemoteUrl createRemoteUrl() {
        return new RemoteUrl(this.testClass.getEndpoint(), this.testClass.getName());
    }

    private RemoteUrl createRemoteUrl(String methodName) {
        return new RemoteUrl(this.testClass.getEndpoint(), this.testClass.getName(), methodName);
    }

    private String sendPut(RemoteUrl url) throws IOException {
        return this.sendRequest("PUT", url);
    }

    private String sendPost(RemoteUrl url) throws IOException {
        return this.sendRequest("POST", url);
    }

    private String sendDelete(RemoteUrl url) throws IOException {
        return this.sendRequest("DELETE", url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(String method, RemoteUrl url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.connectionFactory.createConnection(url);
        try {
            conn.setRequestMethod(method);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                this.handleError(conn);
            }
            String string = this.handleResponse(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private void handleError(HttpURLConnection conn) throws IOException {
        InputStream err = conn.getErrorStream();
        String message = err != null ? Strings.toString(err) : conn.getResponseMessage();
        throw new RemoteException(message);
    }

    private String handleResponse(HttpURLConnection conn) throws IOException {
        return Strings.toString(conn.getInputStream());
    }
}

