/*
 * Decompiled with CFR 0.152.
 */
package org.junit.remote.endpoint;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.remote.RemoteException;
import org.junit.remote.internal.RemoteExecutor;
import org.junit.remote.internal.RemoteTestResult;
import org.junit.remote.internal.RemoteUrl;

public class Endpoint
extends HttpServlet {
    private final Map<String, RemoteExecutor> executors = new HashMap<String, RemoteExecutor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteUrl url = RemoteUrl.forRequest(request);
        String className = url.getClassName();
        RemoteExecutor executor = new RemoteExecutor(className);
        Map<String, RemoteExecutor> map = this.executors;
        synchronized (map) {
            this.executors.put(className, executor);
        }
        executor.setUpClass();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteUrl url = RemoteUrl.forRequest(request);
        RemoteExecutor executor = this.executors.get(url.getClassName());
        Endpoint.checkExecutor(executor);
        PrintWriter writer = response.getWriter();
        RemoteTestResult result = executor.runMethod(url.getMethodName());
        result.writeTo(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteExecutor executor;
        RemoteUrl url = RemoteUrl.forRequest(request);
        Map<String, RemoteExecutor> map = this.executors;
        synchronized (map) {
            executor = this.executors.remove(url.getClassName());
        }
        Endpoint.checkExecutor(executor);
        executor.tearDownClass();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            super.service(request, response);
        }
        catch (Throwable t) {
            Throwable cause;
            this.log("Unexpected problem processing request:", t);
            if (t instanceof RemoteException && (cause = t.getCause()) != null) {
                t = cause;
            }
            Endpoint.sendError(response, t);
        }
    }

    private static void checkExecutor(RemoteExecutor executor) {
        if (executor == null) {
            throw new IllegalStateException("Uninitialized executor; missing PUT");
        }
    }

    private static void sendError(HttpServletResponse response, Throwable cause) throws IOException {
        assert (response != null);
        assert (cause != null);
        response.setStatus(500);
        PrintWriter writer = response.getWriter();
        writer.print(cause);
    }
}

