/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.internal.soa.esb.assertion.AssertArgument;

public abstract class SSLUtil {
    public static KeyManager[] getKeyManagers(KeyStore keystore, String password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        AssertArgument.isNotNull(keystore, "keystore");
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(keystore, password != null ? password.toCharArray() : null);
        return factory.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        AssertArgument.isNotNull(keystore, "keystore");
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        return factory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(InputStream keystoreStream, String keystoreType, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        AssertArgument.isNotNull(keystoreStream, "keystoreStream");
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        try {
            keystore.load(keystoreStream, password != null ? password.toCharArray() : null);
        }
        finally {
            keystoreStream.close();
        }
        return keystore;
    }
}

