/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;
import org.jboss.internal.soa.esb.message.format.xml.MessageImpl;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageType;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static TransformerFactory factory = TransformerFactory.newInstance();
    private static final SimpleDateFormat s_oTS = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS");

    private Util() {
    }

    public static void dumpSysProps(PrintStream p_OS) {
        Object[] sa = new String[ModulePropertyManager.getPropertyManager("transports").getProperties().size()];
        ModulePropertyManager.getPropertyManager("transports").getProperties().keySet().toArray(sa);
        Arrays.sort(sa);
        for (Object sCurr : sa) {
            p_OS.println((String)sCurr + "=" + ModulePropertyManager.getPropertyManager("transports").getProperty((String)sCurr));
        }
    }

    public static boolean isNullString(String p_s) {
        return null == p_s ? true : p_s.trim().length() < 1;
    }

    public static boolean isLong(String p_s) {
        if (Util.isNullString(p_s)) {
            return false;
        }
        try {
            Long.parseLong(p_s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPositiveLong(String p_s) {
        if (Util.isNullString(p_s)) {
            return false;
        }
        try {
            long lBk = Long.parseLong(p_s);
            return lBk > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int parseInt(String s) {
        if (s == null) {
            return 0;
        }
        String sVal = s.trim();
        if (sVal.length() < 1) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static long parseLong(String s) {
        if (s == null) {
            return 0L;
        }
        String sVal = s.trim();
        if (sVal.length() < 1) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public static Logger getDefaultLogger(Class p_oCls) {
        Logger oRet = Logger.getLogger((String)p_oCls.getName());
        ConsoleAppender oApp = new ConsoleAppender((Layout)new TTCCLayout("ISO8601"));
        oRet.addAppender((Appender)oApp);
        return oRet;
    }

    public static Serializable serialize(Message message) throws ParserConfigurationException, IOException {
        if (message.getType().equals(MessageType.JAVA_SERIALIZED)) {
            return (Serializable)((Object)message);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter out = XMLHelper.getXMLStreamWriter(baos);
            String origURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_ENVELOPE);
            ((MessageImpl)message).writeContent(out);
            StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_ENVELOPE.getPrefix(), origURI);
            out.flush();
            int size = baos.toByteArray().length;
            message.getProperties().setProperty("org.jboss.soa.esb.message.byte.size", "" + size);
            return baos.toString();
        }
        catch (XMLStreamException xmlse) {
            IOException ioe = new IOException("Util.serialize caught XMLStreamException:");
            ioe.initCause(xmlse);
            throw ioe;
        }
    }

    public static Message deserialize(Serializable serial) throws ParserConfigurationException, SAXException, IOException {
        if (serial instanceof Message) {
            return (Message)((Object)serial);
        }
        try {
            int size = ((String)((Object)serial)).getBytes().length;
            StringReader reader = new StringReader((String)((Object)serial));
            XMLStreamReader in = XMLHelper.getXMLStreamReader(reader);
            StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_ENVELOPE);
            MessageImpl mess = new MessageImpl(in);
            mess.getProperties().setProperty("org.jboss.soa.esb.message.byte.size", "" + size);
            return mess;
        }
        catch (XMLStreamException xmlse) {
            IOException ioe = new IOException("Util.deserialize caught XMLStreamException");
            ioe.initCause(xmlse);
            throw ioe;
        }
    }

    public static List<KeyValuePair> propertiesFromSelector(String selector) {
        ArrayList<KeyValuePair> oRet = new ArrayList<KeyValuePair>();
        if (!Util.isNullString(selector)) {
            for (String sCurr : selector.trim().split("AND")) {
                String[] sa = sCurr.split("=");
                String attr = null;
                String value = null;
                boolean fail = false;
                if (sa.length == 2) {
                    attr = sa[0].trim();
                    value = sa[1].trim();
                    if (value.charAt(0) != '\'' || value.charAt(value.length() - 1) != '\'') {
                        fail = true;
                    }
                } else {
                    fail = true;
                }
                if (fail) {
                    throw new IllegalArgumentException("Illegal message selector syntax <" + selector + ">.  Must be 2 tokens seperated by an '=' character, and the token after the '=' character must be enclosed in single quotes.");
                }
                KeyValuePair oNew = new KeyValuePair(attr, value.substring(0, -1 + value.length()).substring(1));
                oRet.add(oNew);
            }
        }
        return oRet;
    }

    public static String getStamp() {
        return s_oTS.format(new Date(System.currentTimeMillis()));
    }

    public static String format(String output) {
        if (!output.startsWith("<?xml")) {
            return output;
        }
        StreamSource source = new StreamSource(new ByteArrayInputStream(output.getBytes()));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            try {
                factory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception e) {
                // empty catch block
            }
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setErrorListener(new NullErrorListener());
            transformer.transform(source, new StreamResult(outStream));
            return outStream.toString();
        }
        catch (Exception e) {
            return output;
        }
    }

    private static class NullErrorListener
    implements ErrorListener {
        private NullErrorListener() {
        }

        public void warning(TransformerException exception) throws TransformerException {
        }

        public void error(TransformerException exception) throws TransformerException {
        }

        public void fatalError(TransformerException exception) throws TransformerException {
        }
    }
}

