/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jboss.soa.esb.services.security.SecurityServiceException;

public final class CryptoUtil {
    private CryptoUtil() {
    }

    public static byte[] decrypt(byte[] bytes, PrivateKey key, String transformation) throws SecurityServiceException {
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, key);
            return cipher.doFinal(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    public static byte[] encrypt(byte[] text, PublicKey key, String transformation) throws SecurityServiceException {
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, key);
            return cipher.doFinal(text);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    public static byte[] copyBytes(byte[] bytes, int length) {
        byte[] newArr = null;
        if (bytes.length == length) {
            newArr = bytes;
        } else {
            newArr = new byte[length];
            for (int i = 0; i < length; ++i) {
                newArr[i] = bytes[i];
            }
        }
        return newArr;
    }
}

