/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.principals.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationRequestImpl
implements Serializable,
AuthenticationRequest {
    private static final long serialVersionUID = 1L;
    private Principal principal;
    private Set<?> credentials;
    private Map<String, ?> properties;

    @Override
    public Set<?> getCredentials() {
        return this.credentials;
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    private AuthenticationRequestImpl(Builder builder) {
        this.principal = builder.principal;
        this.credentials = builder.credentials;
        this.properties = builder.properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Principal principal;
        private Set<Object> credentials = new HashSet<Object>();
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Builder() {
        }

        public Builder(Principal principal, Set<Object> credentials) {
            this.principal = principal;
            if (credentials != null) {
                this.credentials.addAll(credentials);
            }
        }

        public Builder property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder username(String username) {
            this.principal = new User(username);
            return this;
        }

        public Builder password(char[] password) {
            this.credentials.add(password);
            return this;
        }

        public AuthenticationRequest build() {
            return new AuthenticationRequestImpl(this);
        }
    }
}

