/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityService;
import org.jboss.soa.esb.util.ClassUtil;

public class SecurityServiceFactory {
    private static Logger log = Logger.getLogger(SecurityServiceFactory.class);
    private static SecurityService instance;

    private SecurityServiceFactory() {
    }

    public static synchronized SecurityService getSecurityService() throws ConfigurationException {
        if (instance != null) {
            return instance;
        }
        String className = Configuration.getSecurityServiceImplementationClass();
        if (className == null) {
            throw new ConfigurationException("No SecurityService implementation has been set. Please check the configuration");
        }
        SecurityService service = null;
        try {
            log.info((Object)("Using [" + className + "] as the SecurityService implementation."));
            Class securityClass = ClassUtil.forName(className, SecurityService.class);
            service = (SecurityService)securityClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("SecurityService Implementation=" + className + " not found", e);
        }
        catch (Exception e) {
            throw new ConfigurationException("Invocation exception. " + e.getLocalizedMessage(), e);
        }
        instance = service;
        return service;
    }
}

