/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.PrivateCryptoUtil;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Subject subject;
    private Set<?> pubCredentials;
    private Set<?> privCredentials;

    public SecurityContext() {
        this.subject = new Subject();
    }

    public SecurityContext(Subject subject) {
        AssertArgument.isNotNull(subject, "subject");
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext [" + this.subject + "]";
    }

    public boolean isCallerInRole(String roleName) {
        Set<Principal> principals = this.subject.getPrincipals();
        for (Principal principal : principals) {
            Group group;
            if (!(principal instanceof Group) || !(group = (Group)principal).getName().equalsIgnoreCase("Roles")) continue;
            Enumeration roles = group.members();
            while (roles.hasMoreElements()) {
                Principal role = (Principal)roles.nextElement();
                if (!role.getName().equals(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.subject.getPrivateCredentials());
        out.writeObject(this.subject.getPublicCredentials());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.privCredentials = (Set)in.readObject();
        this.pubCredentials = (Set)in.readObject();
    }

    final Set<? extends Principal> getPrincipals() {
        return Collections.unmodifiableSet(this.subject.getPrincipals());
    }

    final Set<?> getPubCredentials() {
        return Collections.unmodifiableSet(this.pubCredentials);
    }

    public Set<?> getPrivCredentials() {
        return Collections.unmodifiableSet(this.privCredentials);
    }

    public boolean compareTo(AuthenticationRequest authrequest) {
        if (authrequest == null) {
            return false;
        }
        Principal authPrincipal = authrequest.getPrincipal();
        if (this.subject.getPrincipals().contains(authPrincipal)) {
            Set<?> authCredentials = authrequest.getCredentials();
            Set<Object> publicCredentials = this.subject.getPublicCredentials();
            for (Object object : authCredentials) {
                if (!publicCredentials.contains(object)) continue;
                return true;
            }
            Set<Object> privateCredentials = this.subject.getPrivateCredentials();
            for (Object object : authCredentials) {
                if (!privateCredentials.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static SecurityContext decryptContext(byte[] encrypt) throws SecurityServiceException {
        SecurityContext context = null;
        if (encrypt == null) {
            return context;
        }
        Serializable decrypted = PrivateCryptoUtil.INSTANCE.decrypt(encrypt);
        if (decrypted instanceof SecurityContext) {
            Set<?> privCreds;
            context = (SecurityContext)decrypted;
            Subject subject = context.getSubject();
            Set<?> publCreds = context.getPubCredentials();
            if (publCreds != null) {
                subject.getPublicCredentials().addAll(publCreds);
            }
            if ((privCreds = context.getPrivCredentials()) != null) {
                subject.getPrivateCredentials().addAll(privCreds);
            }
        }
        return context;
    }

    public static byte[] encryptContext(SecurityContext context) throws SecurityServiceException {
        return PrivateCryptoUtil.INSTANCE.encrypt(context);
    }
}

