/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.Email;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;
import org.jboss.soa.esb.util.Util;

public class NotifyEmail
extends NotificationTarget {
    private static final String MESSAGE_ATTACHMENT_NAME = "msgAttachmentName";
    private MessagePayloadProxy payloadProxy;

    public NotifyEmail(ConfigTree configTree) throws ConfigurationException {
        super(configTree);
        try {
            String sAtt = this.m_oParms.getAttribute("from");
            if (null != sAtt) {
                InternetAddress.parse((String)sAtt);
            }
            InternetAddress.parse((String)this.m_oParms.getAttribute("sendTo"));
            sAtt = this.m_oParms.getAttribute("ccTo");
            if (null != sAtt) {
                InternetAddress.parse((String)sAtt);
            }
        }
        catch (AddressException ex) {
            throw new ConfigurationException(ex);
        }
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    public void sendNotification(Message message) throws NotificationException {
        try {
            byte[] payloadBytes;
            String content;
            Object obj = this.payloadProxy.getPayload(message);
            if (obj instanceof byte[]) {
                content = new String((byte[])obj);
                payloadBytes = (byte[])((byte[])obj).clone();
            } else {
                content = obj.toString();
                payloadBytes = content.getBytes();
            }
            ConfigTree oP = this.m_oParms.cloneObj();
            String sMsg = oP.getAttribute("message");
            sMsg = null == sMsg ? content : sMsg + "\n" + content;
            oP.setAttribute("message", sMsg);
            this.sendEmailNotification(oP, payloadBytes);
        }
        catch (MessageDeliverException e) {
            throw new NotificationException(e);
        }
        catch (AddressException e) {
            Util.getDefaultLogger(this.getClass()).error((Object)"Send Mail Failed", (Throwable)e);
            throw new NotificationException(e);
        }
        catch (MessagingException ex) {
            throw new NotificationException(ex);
        }
        catch (IOException e) {
            Util.getDefaultLogger(this.getClass()).error((Object)"Send Mail Failed", (Throwable)e);
            throw new NotificationException(e);
        }
    }

    protected void sendEmailNotification(ConfigTree messageParams, byte[] msgPayload) throws AddressException, MessagingException, IOException {
        Email esbMail = new Email();
        esbMail.setSendTo(messageParams.getAttribute("sendTo"));
        esbMail.setFrom(messageParams.getAttribute("from"));
        esbMail.setCopyTo(messageParams.getAttribute("ccTo"));
        esbMail.setSubject(messageParams.getAttribute("subject"));
        esbMail.setAttachments(messageParams.getTextChildren("attachment"));
        if (messageParams.getAttribute(MESSAGE_ATTACHMENT_NAME) != null) {
            esbMail.addAttachment(new ByteArrayInputStream(msgPayload), messageParams.getAttribute(MESSAGE_ATTACHMENT_NAME));
        } else {
            esbMail.setMessage(messageParams.getAttribute("message"));
        }
        esbMail.sendMessage();
    }
}

