/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.message.body.content;

import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.body.content.InvalidPayloadException;
import org.jboss.soa.esb.message.body.content.MapBody;
import org.jboss.soa.esb.message.body.content.ObjectBody;
import org.jboss.soa.esb.message.body.content.TextBody;
import org.jboss.soa.esb.message.format.MessageFactory;

public class Payload {
    public static final String CONTENT_TYPE = "org.jboss.soa.esb.message.body.content";
    public static final String RAW_BODY = "raw";
    public static final String BYTES_BODY = "bytes";
    public static final String MAP_BODY = "map";
    public static final String OBJECT_BODY = "object";
    public static final String TEXT_BODY = "text";

    public static final String bodyType(Message msg) {
        if (msg == null || msg.getBody() == null) {
            throw new IllegalArgumentException();
        }
        Body body = msg.getBody();
        String type = (String)body.get(CONTENT_TYPE);
        if (type == null) {
            return RAW_BODY;
        }
        return type;
    }

    public static final BytesBody createBytesBody(Message msg) throws InvalidPayloadException {
        if (msg == null || msg.getBody() == null) {
            return null;
        }
        Payload.checkType(msg, BYTES_BODY);
        return (BytesBody)MessageFactory.getInstance().createBodyType(msg, BYTES_BODY);
    }

    public static final MapBody createMapBody(Message msg) throws InvalidPayloadException {
        if (msg == null || msg.getBody() == null) {
            return null;
        }
        Payload.checkType(msg, MAP_BODY);
        return (MapBody)MessageFactory.getInstance().createBodyType(msg, MAP_BODY);
    }

    public static final ObjectBody createObjectBody(Message msg) throws InvalidPayloadException {
        if (msg == null || msg.getBody() == null) {
            return null;
        }
        Payload.checkType(msg, OBJECT_BODY);
        return (ObjectBody)MessageFactory.getInstance().createBodyType(msg, OBJECT_BODY);
    }

    public static final TextBody createTextBody(Message msg) throws InvalidPayloadException {
        if (msg == null || msg.getBody() == null) {
            return null;
        }
        Payload.checkType(msg, TEXT_BODY);
        return (TextBody)MessageFactory.getInstance().createBodyType(msg, TEXT_BODY);
    }

    private static final void checkType(Message msg, String required) throws InvalidPayloadException {
        String type = (String)msg.getBody().get(CONTENT_TYPE);
        if (type != null && !type.equals(required)) {
            throw new InvalidPayloadException();
        }
    }
}

