/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.ActionStatusBean;

public class ServiceMessageCounter
implements DynamicMBean {
    private Hashtable<String, IntHolder> actionCounterHash = new Hashtable();
    private Hashtable<String, IntHolder> actionFailedCounterHash = new Hashtable();
    private Hashtable<String, LongHolder> actionProcessTimeHash = new Hashtable();
    private Hashtable<String, IntHolder> actionBytesProcessedHash = new Hashtable();
    private Hashtable<String, IntHolder> actionBytesFailedHash = new Hashtable();
    private String[] actionNames;
    private final ObjectName listObjectName;
    private int serviceCount;
    private long bytesFailed;
    private long bytesProcessed;
    public static final String RESET_COUNTER = "resetCounter";
    private static final String MESSAGE_COUNTER = "messages successfully processed count";
    private static final String FAILED_MESSAGE_COUNTER = "messages failed count";
    private static final String PROCESSING_TIME = "processing time";
    private static final String BYTES_FAILED = "failed bytes";
    private static final String BYTES_PROCESSED = "processed bytes";
    private static final String OVERALL_SERVICE_COUNT = "overall service message count";
    private static final String OVERALL_BYTES_PROCESSED = "overall processedbytes";
    private static final String OVERALL_BYTES_FAILED = "overall failed bytes";
    private static final Logger logger = Logger.getLogger(ServiceMessageCounter.class);

    public ServiceMessageCounter(ConfigTree f_config, String objectName) {
        this.init(f_config);
        ObjectName listObjectName = null;
        try {
            listObjectName = new ObjectName("jboss.esb:" + objectName);
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception creating MBean object name, counter will be unregistered", (Throwable)ex);
        }
        this.listObjectName = listObjectName;
    }

    private String getActionId(ConfigTree ct) {
        if (ct.getAttribute("name") != null) {
            return ct.getAttribute("name");
        }
        if (ct.getAttribute("action") != null) {
            return ct.getAttribute("action");
        }
        return null;
    }

    public synchronized void incrementTotalCount() {
        ++this.serviceCount;
    }

    private void init(ConfigTree configTree) {
        ConfigTree[] actionList = configTree.getChildren("action");
        int numActions = actionList.length;
        this.actionNames = new String[numActions];
        for (int count = 0; count < numActions; ++count) {
            ConfigTree actionConfig = actionList[count];
            String actionId = this.getActionId(actionConfig);
            this.actionCounterHash.put(actionId + " " + MESSAGE_COUNTER, new IntHolder());
            this.actionFailedCounterHash.put(actionId + " " + FAILED_MESSAGE_COUNTER, new IntHolder());
            this.actionProcessTimeHash.put(actionId + " " + PROCESSING_TIME, new LongHolder());
            this.actionBytesFailedHash.put(actionId + " " + BYTES_FAILED, new IntHolder());
            this.actionBytesProcessedHash.put(actionId + " " + BYTES_PROCESSED, new IntHolder());
            this.actionNames[count] = actionId;
        }
        this.serviceCount = new Integer(0);
        this.bytesProcessed = new Integer(0).intValue();
        this.bytesFailed = new Integer(0).intValue();
    }

    public synchronized void resetCounter() {
        this.serviceCount = 0;
        this.bytesProcessed = 0L;
        this.bytesFailed = 0L;
        for (String key : this.actionCounterHash.keySet()) {
            this.actionCounterHash.put(key, new IntHolder());
        }
        for (String key : this.actionFailedCounterHash.keySet()) {
            this.actionFailedCounterHash.put(key, new IntHolder());
        }
        for (String key : this.actionProcessTimeHash.keySet()) {
            this.actionProcessTimeHash.put(key, new LongHolder());
        }
        for (String key : this.actionBytesFailedHash.keySet()) {
            this.actionBytesFailedHash.put(key, new IntHolder());
        }
        for (String key : this.actionBytesProcessedHash.keySet()) {
            this.actionBytesProcessedHash.put(key, new IntHolder());
        }
    }

    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo overallBytesFailed;
        MBeanAttributeInfo overallBytesProcessed;
        MBeanAttributeInfo overallCount;
        int count = this.actionCounterHash.size() + this.actionProcessTimeHash.size() + this.actionFailedCounterHash.size() + this.actionBytesProcessedHash.size() + this.actionBytesFailedHash.size() + 3;
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[count];
        int counter = 0;
        for (String key : this.actionCounterHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionProcessTimeHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Double", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionFailedCounterHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionBytesFailedHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        for (String key : this.actionBytesProcessedHash.keySet()) {
            attrs[counter] = new MBeanAttributeInfo(key, "java.lang.Integer", "Property " + key, true, false, false);
            ++counter;
        }
        attrs[counter] = overallCount = new MBeanAttributeInfo(OVERALL_SERVICE_COUNT, "java.lang.Integer", "Property overall service message count", true, false, false);
        attrs[++counter] = overallBytesProcessed = new MBeanAttributeInfo(OVERALL_BYTES_PROCESSED, "java.lang.Integer", "Property overall processedbytes", true, false, false);
        attrs[++counter] = overallBytesFailed = new MBeanAttributeInfo(OVERALL_BYTES_FAILED, "java.lang.Integer", "Property overall failed bytes", true, false, false);
        ++counter;
        MBeanOperationInfo[] opers = new MBeanOperationInfo[]{new MBeanOperationInfo(RESET_COUNTER, "Reset the counter", null, "void", 1)};
        return new MBeanInfo(this.getClass().getName(), "Service Message Counter MBean", attrs, null, opers, null);
    }

    public synchronized Object getAttribute(String key) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.actionCounterHash.containsKey(key)) {
            return this.actionCounterHash.get((Object)key).value;
        }
        if (this.actionProcessTimeHash.containsKey(key)) {
            long processTotal = this.actionProcessTimeHash.get((Object)key).value;
            String actionId = key.substring(0, key.indexOf(PROCESSING_TIME) - 1);
            int successCount = this.actionCounterHash.get((Object)new StringBuilder().append((String)actionId).append((String)" ").append((String)MESSAGE_COUNTER).toString()).value;
            Double value = null;
            value = successCount > 0 ? Double.valueOf((double)processTotal / (double)successCount) : null;
            return value;
        }
        if (this.actionFailedCounterHash.containsKey(key)) {
            return this.actionFailedCounterHash.get((Object)key).value;
        }
        if (this.actionBytesFailedHash.containsKey(key)) {
            return this.actionBytesFailedHash.get((Object)key).value;
        }
        if (this.actionBytesProcessedHash.containsKey(key)) {
            return this.actionBytesProcessedHash.get((Object)key).value;
        }
        if (OVERALL_SERVICE_COUNT.equals(key)) {
            return this.serviceCount;
        }
        if (OVERALL_BYTES_PROCESSED.equals(key)) {
            return this.bytesProcessed;
        }
        if (OVERALL_BYTES_FAILED.equals(key)) {
            return this.bytesFailed;
        }
        return null;
    }

    public synchronized AttributeList getAttributes(String[] arg0) {
        AttributeList attributeList = new AttributeList();
        for (String key : this.actionCounterHash.keySet()) {
            Attribute at = new Attribute(key, this.actionCounterHash.get(key).toString());
            attributeList.add(at);
        }
        Attribute overallCount = new Attribute(OVERALL_SERVICE_COUNT, this.serviceCount);
        attributeList.add(overallCount);
        for (String key : this.actionProcessTimeHash.keySet()) {
            long processTotal = this.actionProcessTimeHash.get((Object)key).value;
            String actionId = key.substring(0, key.indexOf(PROCESSING_TIME));
            int successCount = this.actionCounterHash.get((Object)new StringBuilder().append((String)actionId).append((String)" ").append((String)MESSAGE_COUNTER).toString()).value;
            String avgTime = null;
            if (successCount > 0) {
                avgTime = (double)processTotal / (double)successCount + " ns";
            }
            Attribute at = new Attribute(key, avgTime);
            attributeList.add(at);
        }
        for (String key : this.actionFailedCounterHash.keySet()) {
            Attribute at = new Attribute(key, this.actionFailedCounterHash.get(key).toString());
            attributeList.add(at);
        }
        for (String key : this.actionBytesFailedHash.keySet()) {
            Attribute at = new Attribute(key, this.actionBytesFailedHash.get(key).toString());
            attributeList.add(at);
        }
        for (String key : this.actionBytesProcessedHash.keySet()) {
            Attribute at = new Attribute(key, this.actionBytesProcessedHash.get(key).toString());
            attributeList.add(at);
        }
        return attributeList;
    }

    public Object invoke(String method, Object[] arg1, String[] arg2) throws MBeanException, ReflectionException {
        if (method.equalsIgnoreCase(RESET_COUNTER)) {
            this.resetCounter();
            return "Invoking the " + method + " on the lifecycle.";
        }
        throw new ReflectionException(new NoSuchMethodException(method));
    }

    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList setAttributes(AttributeList arg0) {
        return null;
    }

    protected void registerMBean() {
        if (this.listObjectName == null) {
            return;
        }
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            mbeanServer.registerMBean(this, this.listObjectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.warn((Object)"", (Throwable)e);
        }
    }

    protected void unregisterMBean() {
        if (this.listObjectName == null) {
            return;
        }
        MBeanServer mbeanServer = null;
        try {
            mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            mbeanServer.unregisterMBean(this.listObjectName);
        }
        catch (InstanceNotFoundException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.warn((Object)"", (Throwable)e);
        }
    }

    public synchronized void update(ActionStatusBean asb) {
        String actionName = this.actionNames[asb.getProcCount()];
        if ("SENT".equals(asb.getStatus())) {
            IntHolder count = this.actionCounterHash.get(actionName + " " + MESSAGE_COUNTER);
            ++count.value;
            LongHolder time = this.actionProcessTimeHash.get(actionName + " " + PROCESSING_TIME);
            time.value += asb.getProcTime();
            IntHolder bProcessed = this.actionBytesProcessedHash.get(actionName + " " + BYTES_PROCESSED);
            bProcessed.value += asb.getBytesProcessed();
            this.bytesProcessed += (long)asb.getBytesProcessed();
        } else if ("FAILED".equals(asb.getStatus())) {
            IntHolder count = this.actionFailedCounterHash.get(actionName + " " + FAILED_MESSAGE_COUNTER);
            ++count.value;
            LongHolder time = this.actionProcessTimeHash.get(actionName + " " + PROCESSING_TIME);
            time.value += asb.getProcTime();
            IntHolder bFailed = this.actionBytesFailedHash.get(actionName + " " + BYTES_FAILED);
            bFailed.value += asb.getBytesProcessed();
            this.bytesFailed += (long)asb.getBytesProcessed();
        }
    }

    protected ObjectName getObjectName() {
        return this.listObjectName;
    }

    private static final class LongHolder {
        long value;

        private LongHolder() {
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private static final class IntHolder {
        int value;

        private IntHolder() {
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

