/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

class ActionProcessorMethodInfo {
    private static final Logger LOGGER = Logger.getLogger(ActionProcessorMethodInfo.class);
    private final Method[] processMethods;
    private final Method processSuccess;
    private final Method processException;

    private ActionProcessorMethodInfo(Method[] processMethods, Method processSuccess, Method processException) {
        this.processMethods = processMethods;
        this.processSuccess = processSuccess;
        this.processException = processException;
    }

    boolean hasProcessMethods() {
        return this.processMethods != null;
    }

    Message processMethods(Object instance, Message message) throws ActionProcessingException {
        Message currentMessage = message;
        if (this.hasProcessMethods()) {
            for (Method processMethod : this.processMethods) {
                try {
                    Object response = processMethod.invoke(instance, currentMessage);
                    if (!(response instanceof Message)) {
                        if (response == null) {
                            return null;
                        }
                        throw new ActionProcessingException("Unexpected response type from processor: " + response);
                    }
                    currentMessage = (Message)response;
                }
                catch (IllegalAccessException iae) {
                    throw new ActionProcessingException("Illegal access from processor", iae);
                }
                catch (InvocationTargetException ite) {
                    Throwable th = ite.getTargetException();
                    if (th instanceof ActionProcessingException) {
                        throw (ActionProcessingException)th;
                    }
                    if (th instanceof RuntimeException) {
                        throw (RuntimeException)th;
                    }
                    if (th instanceof Error) {
                        throw (Error)th;
                    }
                    throw new ActionProcessingException("Unexpected invocation target exception from processor", th);
                }
            }
        }
        return currentMessage;
    }

    boolean hasProcessSuccess() {
        return this.processSuccess != null;
    }

    void processSuccess(Object instance, Message message) {
        if (this.hasProcessSuccess()) {
            try {
                this.processSuccess.invoke(instance, message);
            }
            catch (IllegalAccessException iae) {
                LOGGER.warn((Object)"Illegal access from processor", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                Throwable th = ite.getTargetException();
                LOGGER.warn((Object)"Unexpected invocation target exception from processor", th);
            }
        }
    }

    boolean hasProcessException() {
        return this.processException != null;
    }

    void processException(Object instance, Message message, Throwable th) {
        if (this.hasProcessException()) {
            try {
                this.processException.invoke(instance, message, th);
            }
            catch (IllegalAccessException iae) {
                LOGGER.warn((Object)"Illegal access from processor", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                LOGGER.warn((Object)"Unexpected invocation target exception from processor", ite.getTargetException());
            }
        }
    }

    static boolean checkOverridden(ConfigTree actionConfig) {
        String exceptionMethod;
        String successMethod;
        String processMethod = actionConfig.getAttribute("process");
        return processMethod != null && !"process".equals(processMethod) || (successMethod = actionConfig.getAttribute("okMethod")) != null && !"processSuccess".equals(successMethod) || (exceptionMethod = actionConfig.getAttribute("exceptionMethod")) != null && !"processException".equals(exceptionMethod);
    }

    static ActionProcessorMethodInfo getMethodInfo(ConfigTree actionConfig, Class actionClass) throws ConfigurationException {
        try {
            String processMethodName = actionConfig.getAttribute("process", "process");
            Method[] processMethods = ActionProcessorMethodInfo.getMethods(actionClass, processMethodName, Message.class);
            String processSuccessName = actionConfig.getAttribute("okMethod");
            Method processSuccess = ActionProcessorMethodInfo.getMethod(actionClass, processSuccessName, Message.class);
            String processExceptionName = actionConfig.getAttribute("exceptionMethod");
            Method processException = ActionProcessorMethodInfo.getMethod(actionClass, processExceptionName, Message.class, Throwable.class);
            return new ActionProcessorMethodInfo(processMethods, processSuccess, processException);
        }
        catch (NoSuchMethodException nsme) {
            throw new ConfigurationException("Invalid processor method in configuration", nsme);
        }
    }

    private static Method[] getMethods(Class actionClass, String methodNameList, Class ... classes) throws NoSuchMethodException {
        String[] methodNames = methodNameList.split(",");
        int numMethodNames = methodNames == null ? 0 : methodNames.length;
        Method[] methods = new Method[numMethodNames];
        for (int count = 0; count < numMethodNames; ++count) {
            String methodName = methodNames[count].trim();
            methods[count] = ActionProcessorMethodInfo.getMethod(actionClass, methodName, classes);
        }
        return methods;
    }

    private static Method getMethod(Class actionClass, String methodName, Class ... classes) throws NoSuchMethodException {
        if (methodName != null) {
            return actionClass.getMethod(methodName, classes);
        }
        return null;
    }

    static Constructor getActionClassConstructor(Class actionClass) throws ConfigurationException {
        try {
            return actionClass.getConstructor(ConfigTree.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ConfigurationException("Action " + actionClass.getName() + " does not have correct constructor");
        }
    }

    static Object getActionClassInstance(ConfigTree actionConfig, Class actionClass) throws ConfigurationException {
        return ActionProcessorMethodInfo.getActionClassInstance(actionConfig, ActionProcessorMethodInfo.getActionClassConstructor(actionClass));
    }

    static Object getActionClassInstance(ConfigTree actionConfig, Constructor actionConstructor) throws ConfigurationException {
        try {
            return actionConstructor.newInstance(actionConfig);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unexpected exception while instantiating action instance", ex);
        }
    }
}

