/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.message;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycle;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingFaultException;
import org.jboss.soa.esb.actions.BeanConfiguredAction;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.LogicalEPR;
import org.jboss.soa.esb.addressing.util.DefaultFaultTo;
import org.jboss.soa.esb.addressing.util.DefaultReplyTo;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.listeners.message.ActionProcessorMethodInfo;
import org.jboss.soa.esb.listeners.message.ActionStatusBean;
import org.jboss.soa.esb.listeners.message.BeanConfigActionProcessor;
import org.jboss.soa.esb.listeners.message.MessageCounterStatistics;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.listeners.message.MessageStatusBean;
import org.jboss.soa.esb.listeners.message.MessageValidationException;
import org.jboss.soa.esb.listeners.message.OverriddenActionLifecycleProcessor;
import org.jboss.soa.esb.listeners.message.OverriddenActionPipelineProcessor;
import org.jboss.soa.esb.listeners.message.OverriddenActionProcessor;
import org.jboss.soa.esb.listeners.message.ServiceMessageCounter;
import org.jboss.soa.esb.listeners.message.ServiceMessageCounterLifecycleResource;
import org.jboss.soa.esb.listeners.message.errors.Factory;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.services.security.PublicCryptoUtil;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityConfigUtil;
import org.jboss.soa.esb.services.security.SecurityContext;
import org.jboss.soa.esb.services.security.SecurityService;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.SecurityServiceFactory;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.util.ClassUtil;
import org.xml.sax.SAXException;

public class ActionProcessingPipeline {
    private static final Logger LOGGER = Logger.getLogger(ActionProcessingPipeline.class);
    private final ActionPipelineProcessor[] processors;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Schema requestSchema;
    private final Schema responseSchema;
    private final ServiceMessageCounter serviceMessageCounter;
    private boolean transactional;
    private final boolean oneWay;
    private final boolean defaultProcessing;
    private SecurityConfig securityConf;

    public ActionProcessingPipeline(ConfigTree config) throws ConfigurationException {
        boolean defaultProcessing;
        boolean oneWay;
        if (config == null) {
            throw new IllegalArgumentException("Configuration needed for action classes");
        }
        String mep = config.getAttribute("mep");
        if (mep == null) {
            oneWay = false;
            defaultProcessing = true;
        } else if ("OneWay".equals(mep)) {
            oneWay = true;
            defaultProcessing = false;
        } else if ("RequestResponse".equals(mep)) {
            oneWay = false;
            defaultProcessing = false;
        } else {
            throw new ConfigurationException("Unrecognised action MEP: " + mep);
        }
        boolean validate = config.getBooleanAttribute("validate", false);
        if (validate) {
            String inXsd = config.getAttribute("inXsd");
            try {
                this.requestSchema = inXsd == null ? null : XMLHelper.getSchema(inXsd);
            }
            catch (SAXException saxe) {
                throw new ConfigurationException("Failed to parse the request schema: " + inXsd, saxe);
            }
            String outXsd = config.getAttribute("outXsd");
            try {
                this.responseSchema = outXsd == null ? null : XMLHelper.getSchema(outXsd);
            }
            catch (SAXException saxe) {
                throw new ConfigurationException("Failed to parse the response schema: " + outXsd, saxe);
            }
        }
        this.requestSchema = null;
        this.responseSchema = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Using mep: " + mep + ", oneWay: " + oneWay + ", defaultProcessing: " + defaultProcessing));
        }
        this.oneWay = oneWay;
        this.defaultProcessing = defaultProcessing;
        ConfigTree[] actionList = config.getChildren("action");
        if (actionList == null || actionList.length == 0) {
            throw new ConfigurationException("No actions in list");
        }
        ArrayList<BeanConfigActionProcessor> processorList = new ArrayList<BeanConfigActionProcessor>();
        try {
            this.serviceMessageCounter = ServiceMessageCounterLifecycleResource.getServiceMessageCounter(config);
        }
        catch (LifecycleResourceException lre) {
            throw new ConfigurationException("Failed to obtain the service message counter", lre);
        }
        for (ConfigTree actionConfig : actionList) {
            ActionPipelineProcessor processor;
            Class actionClass;
            String actionClassTag = actionConfig.getAttribute("class");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Registering action class " + actionClassTag));
            }
            try {
                actionClass = ClassUtil.forName(actionClassTag, this.getClass());
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException("Could not load action class " + actionClassTag);
            }
            if (BeanConfiguredAction.class.isAssignableFrom(actionClass)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Using bean configured action processor for " + actionClassTag));
                }
                processor = new BeanConfigActionProcessor(actionConfig, actionClass);
            } else if (ActionPipelineProcessor.class.isAssignableFrom(actionClass)) {
                ActionPipelineProcessor currentProcessor = (ActionPipelineProcessor)ActionProcessorMethodInfo.getActionClassInstance(actionConfig, actionClass);
                if (ActionProcessorMethodInfo.checkOverridden(actionConfig)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Using overridden action pipeline processor for " + actionClassTag));
                    }
                    processor = new OverriddenActionPipelineProcessor(actionConfig, currentProcessor);
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Using normal action pipeline processor for " + actionClassTag));
                    }
                    processor = currentProcessor;
                }
            } else if (ActionLifecycle.class.isAssignableFrom(actionClass)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Using overridden action lifecycle processor for " + actionClassTag));
                }
                ActionLifecycle currentLifecycle = (ActionLifecycle)ActionProcessorMethodInfo.getActionClassInstance(actionConfig, actionClass);
                processor = new OverriddenActionLifecycleProcessor(actionConfig, currentLifecycle);
            } else {
                LOGGER.warn((Object)("Action class " + actionClassTag + " does not implement the ActionLifecycle interface"));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Using overridden actions processor for " + actionClassTag));
                }
                processor = new OverriddenActionProcessor(actionConfig, actionClass);
            }
            processorList.add((BeanConfigActionProcessor)processor);
        }
        this.processors = processorList.toArray(new ActionPipelineProcessor[processorList.size()]);
        ConfigTree[] securityConfigs = config.getChildren("security");
        if (securityConfigs.length > 0) {
            this.securityConf = SecurityConfigUtil.createSecurityConfig(securityConfigs[0]);
            LOGGER.debug((Object)this.securityConf);
            SecurityService securitySerivce = SecurityServiceFactory.getSecurityService();
            securitySerivce.configure();
            securitySerivce.refreshSecurityConfig();
        }
    }

    public void initialise() throws ConfigurationException {
        int numLifecycles = this.processors.length;
        for (int count = 0; count < numLifecycles; ++count) {
            ActionPipelineProcessor lifecycle = this.processors[count];
            try {
                lifecycle.initialise();
                continue;
            }
            catch (Exception ex) {
                this.handleDestroy(count - 1);
                throw new ConfigurationException("Unexpected exception during lifecycle initialisation", ex);
            }
        }
        this.active.set(true);
    }

    public void destroy() {
        this.active.set(false);
        this.handleDestroy(this.processors.length - 1);
    }

    public boolean process(Message message) {
        long start = System.nanoTime();
        this.serviceMessageCounter.incrementTotalCount();
        if (this.active.get()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("pipeline process for message: " + message.getHeader()));
            }
            SecurityContext securityContext = null;
            try {
                securityContext = SecurityContext.decryptContext((byte[])message.getContext().getContext("org.jboss.soa.esb.services.security.context"));
            }
            catch (SecurityServiceException e) {
                LOGGER.debug((Object)"Security exception: ", (Throwable)e);
                securityContext = null;
            }
            if (this.securityConf != null || securityContext != null) {
                return this.processPipelineSecured(message, securityContext);
            }
            return this.processPipeline(message);
        }
        Call callDetails = new Call();
        callDetails.copy(message.getHeader().getCall());
        LOGGER.debug((Object)("pipeline process disabled for message: " + message.getHeader()));
        this.faultTo(callDetails, Factory.createErrorMessage("urn:action/error/disabled", message, null));
        long procTime = System.nanoTime() - start;
        MessageCounterStatistics.getMessageCounterStatistics().update(new MessageStatusBean(procTime, message, "FAILED"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPipelineSecured(final Message message, SecurityContext securityContext) {
        Call callDetails = new Call();
        callDetails.copy(message.getHeader().getCall());
        try {
            if (this.securityConf != null) {
                boolean checkRolesAllowed;
                if (securityContext == null) {
                    securityContext = new SecurityContext();
                    byte[] encrypted = (byte[])message.getContext().getContext("org.jboss.soa.esb.services.security.authRequest");
                    if (encrypted == null) {
                        throw new SecurityServiceException("Missing AuthenticationRequest. Cannot be authenticated.");
                    }
                    AuthenticationRequest authRequest = (AuthenticationRequest)((Object)PublicCryptoUtil.INSTANCE.decrypt(encrypted));
                    SecurityServiceFactory.getSecurityService().authenticate(this.securityConf, securityContext, authRequest);
                }
                if (!(checkRolesAllowed = SecurityServiceFactory.getSecurityService().checkRolesAllowed(this.securityConf.getRolesAllowed(), securityContext))) {
                    throw new SecurityServiceException("Caller did not belong to any of the rolesAllowed " + this.securityConf.getRolesAllowed());
                }
            }
        }
        catch (SecurityServiceException e) {
            LOGGER.debug((Object)"SecurityService exception : ", (Throwable)e);
            this.faultTo(callDetails, Factory.createErrorMessage("urn:action/error/unexpectederror", message, e));
            boolean authRequest = false;
            return authRequest;
        }
        catch (ConfigurationException e) {
            LOGGER.debug((Object)"SecurityService exception : ", (Throwable)e);
            this.faultTo(callDetails, Factory.createErrorMessage("urn:action/error/unexpectederror", message, e));
            boolean authRequest = false;
            return authRequest;
        }
        finally {
            message.getContext().removeContext("org.jboss.soa.esb.services.security.context");
            message.getContext().removeContext("org.jboss.soa.esb.services.security.authRequest");
        }
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ActionProcessingPipeline.this.processPipeline(message);
            }
        };
        Boolean processResult = Subject.doAsPrivileged(securityContext.getSubject(), action, null);
        return processResult;
    }

    private boolean processPipeline(Message message) {
        Object input;
        long start = System.nanoTime();
        Call callDetails = new Call();
        callDetails.copy(message.getHeader().getCall());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("pipeline process for message: " + message.getHeader()));
        }
        boolean result = false;
        String validationFailure = null;
        if (!(this.requestSchema == null || (input = message.getBody().get()) != null && XMLHelper.validate(this.requestSchema, input.toString()))) {
            validationFailure = "Request validation failure: " + input;
        }
        if (validationFailure == null) {
            int numProcessors = this.processors.length;
            Message[] messages = new Message[numProcessors];
            Message currentMessage = message;
            for (int count = 0; count < numProcessors; ++count) {
                ActionPipelineProcessor processor = this.processors[count];
                messages[count] = currentMessage;
                long actionStart = System.nanoTime();
                try {
                    LOGGER.debug((Object)("executing processor " + count + " " + processor + " " + message.getHeader()));
                    currentMessage = processor.process(currentMessage);
                }
                catch (Exception ex) {
                    boolean throwRuntime;
                    long procTime = System.nanoTime() - actionStart;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Unexpected exception caught while processing the action pipeline: " + message.getHeader()), (Throwable)ex);
                    }
                    this.notifyException(count, ex, messages);
                    boolean bl = throwRuntime = this.transactional && ex instanceof RuntimeException;
                    if (ex instanceof ActionProcessingFaultException) {
                        ActionProcessingFaultException fault = (ActionProcessingFaultException)ex;
                        if (fault.getFaultMessage() == null) {
                            this.faultTo(callDetails, Factory.createErrorMessage("urn:action/error/actionprocessingerror", message, ex));
                        } else {
                            this.faultTo(callDetails, fault.getFaultMessage());
                        }
                    } else if (!throwRuntime) {
                        this.faultTo(callDetails, Factory.createErrorMessage("urn:action/error/unexpectederror", message, ex));
                    }
                    long totalProcTime = System.nanoTime() - start;
                    this.serviceMessageCounter.update(new ActionStatusBean(procTime, count, message, "FAILED"));
                    MessageCounterStatistics.getMessageCounterStatistics().update(new MessageStatusBean(totalProcTime, message, "FAILED"));
                    if (throwRuntime) {
                        throw (RuntimeException)ex;
                    }
                    return false;
                }
                long procTime = System.nanoTime() - actionStart;
                this.serviceMessageCounter.update(new ActionStatusBean(procTime, count, message, "SENT"));
                if (currentMessage == null) break;
            }
            if (!this.oneWay) {
                if (currentMessage != null) {
                    Object output;
                    if (!(this.responseSchema == null || (output = message.getBody().get()) != null && XMLHelper.validate(this.responseSchema, output.toString()))) {
                        validationFailure = "Response validation failure: " + output;
                    }
                    if (validationFailure == null) {
                        this.replyTo(callDetails, currentMessage);
                    }
                } else if (!this.defaultProcessing) {
                    LOGGER.warn((Object)("No response message for RequestResponse mep! " + callDetails));
                }
            }
            if (validationFailure == null) {
                this.notifySuccess(messages);
                long procTime = System.nanoTime() - start;
                MessageCounterStatistics.getMessageCounterStatistics().update(new MessageStatusBean(procTime, message, "SENT"));
                result = true;
            }
        }
        if (validationFailure != null) {
            MessageValidationException mve = new MessageValidationException(validationFailure);
            this.faultTo(callDetails, Factory.createErrorMessage("urn:action/error/validationFailure", message, mve));
            long procTime = System.nanoTime() - start;
            MessageCounterStatistics.getMessageCounterStatistics().update(new MessageStatusBean(procTime, message, "FAILED"));
        }
        return result;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    private void replyTo(Call callDetails, Message message) {
        if (!DefaultReplyTo.initialiseReply(message, callDetails)) {
            if (this.defaultProcessing) {
                LOGGER.warn((Object)("No reply to address defined for reply message! " + callDetails));
                this.sendToDLQ(callDetails, message, MessageType.reply);
            }
        } else {
            EPR replyToEPR = message.getHeader().getCall().getTo();
            this.messageTo(replyToEPR, message, MessageType.reply);
        }
    }

    private void faultTo(Call callDetails, Message message) {
        if (!DefaultFaultTo.initialiseReply(message, callDetails, this.oneWay)) {
            if (this.defaultProcessing || this.oneWay) {
                LOGGER.warn((Object)("No fault address defined for fault message! " + callDetails));
                this.sendToDLQ(callDetails, message, MessageType.fault);
            }
        } else {
            EPR faultToEPR = message.getHeader().getCall().getTo();
            this.messageTo(faultToEPR, message, MessageType.fault);
        }
    }

    private void sendToDLQ(Call callDetails, Message message, MessageType messageType) {
        Properties properties = message.getProperties();
        properties.setProperty("org.jboss.soa.esb.messagestore.classification", "DLQ");
        properties.setProperty("org.jboss.soa.esb.failure.call", callDetails.toString());
        properties.setProperty("org.jboss.soa.esb.failure.responseType", messageType.name());
        try {
            ServiceInvoker serviceInvoker = new ServiceInvoker(ServiceInvoker.dlqService);
            serviceInvoker.deliverAsync(message);
        }
        catch (MessageDeliverException mde) {
            LOGGER.warn((Object)"Failed to send response failure to DLQ service");
            LOGGER.debug((Object)"Failed to send response failure to DLQ service", (Throwable)mde);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageTo(EPR epr, Message message, MessageType messageType) {
        if (epr instanceof LogicalEPR) {
            try {
                ServiceInvoker invoker = ((LogicalEPR)epr).getServiceInvoker();
                invoker.deliverAsync(message);
            }
            catch (MessageDeliverException e) {
                LOGGER.error((Object)("Failed to send " + (Object)((Object)messageType) + " to address " + epr + " for message " + message.getHeader()), (Throwable)e);
            }
        } else {
            Courier courier = null;
            try {
                courier = CourierFactory.getCourier(epr);
                courier.deliver(message);
            }
            catch (CourierException e) {
                LOGGER.error((Object)("Failed to send " + (Object)((Object)messageType) + " to address " + epr + " for message " + message.getHeader()), (Throwable)e);
            }
            catch (MalformedEPRException e) {
                LOGGER.error((Object)("Failed to send " + (Object)((Object)messageType) + " to address " + epr + " for message " + message.getHeader()), (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error((Object)("Failed to send " + (Object)((Object)messageType) + " to address " + epr + " for message " + message.getHeader()), e);
            }
            finally {
                if (courier != null) {
                    CourierUtil.cleanCourier(courier);
                }
            }
        }
    }

    private void handleDestroy(int initialPosition) {
        for (int count = initialPosition; count >= 0; --count) {
            ActionPipelineProcessor lifecycle = this.processors[count];
            try {
                lifecycle.destroy();
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Unexpected exception during lifecycle destruction", (Throwable)ex);
            }
        }
    }

    private void notifyException(int initialPosition, Exception ex, Message[] messages) {
        for (int count = initialPosition; count >= 0; --count) {
            ActionPipelineProcessor processor = this.processors[count];
            try {
                processor.processException(messages[count], ex);
                continue;
            }
            catch (Exception ex2) {
                LOGGER.warn((Object)"Unexpected exception notifying processor of pipeline failure", (Throwable)ex2);
            }
        }
    }

    private void notifySuccess(Message[] messages) {
        for (int count = messages.length - 1; count >= 0; --count) {
            Message message = messages[count];
            if (message == null) continue;
            ActionPipelineProcessor processor = this.processors[count];
            try {
                processor.processSuccess(messages[count]);
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Unexpected exception notifying processor of pipeline success", (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MessageType {
        reply,
        fault;

    }
}

