/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleState;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleThreadEventListener;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleThreadState;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleThreadStateEvent;

public abstract class AbstractThreadedManagedLifecycle
extends AbstractManagedLifecycle
implements Runnable {
    private static final Logger logger = Logger.getLogger(AbstractThreadedManagedLifecycle.class);
    private final Lock runningLock = new ReentrantLock();
    private final Condition runningChanged = this.runningLock.newCondition();
    private transient ManagedLifecycleThreadState state = ManagedLifecycleThreadState.STOPPED;
    private Set<ManagedLifecycleThreadEventListener> listeners = new CopyOnWriteArraySet<ManagedLifecycleThreadEventListener>();

    protected AbstractThreadedManagedLifecycle(ConfigTree config) throws ConfigurationException {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws ManagedLifecycleException {
        this.runningLock.lock();
        try {
            if (!this.waitUntilStopped()) {
                throw new ManagedLifecycleException("Thread still active from previous start");
            }
            this.setRunning(ManagedLifecycleThreadState.RUNNING);
        }
        finally {
            this.runningLock.unlock();
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.waitUntilNotState(ManagedLifecycleState.STARTING, this.getTerminationPeriod());
        try {
            this.changeState(ManagedLifecycleState.RUNNING);
            this.doRun();
        }
        catch (ManagedLifecycleException mle) {
        }
        catch (Throwable th) {
            logger.warn((Object)"Unexpected error from doRun()", th);
        }
        finally {
            this.setRunning(ManagedLifecycleThreadState.STOPPED);
        }
    }

    protected abstract void doRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws ManagedLifecycleException {
        this.runningLock.lock();
        try {
            if (this.isRunning()) {
                this.setRunning(ManagedLifecycleThreadState.STOPPING);
            }
        }
        finally {
            this.runningLock.unlock();
        }
    }

    protected final void doDestroy() throws ManagedLifecycleException {
        if (!this.waitUntilStopped()) {
            throw new ManagedLifecycleException("Thread still active");
        }
        this.doThreadedDestroy();
    }

    protected void doThreadedDestroy() throws ManagedLifecycleException {
    }

    public boolean isRunning() {
        return this.checkState(ManagedLifecycleThreadState.RUNNING);
    }

    public boolean isStopped() {
        return this.checkState(ManagedLifecycleThreadState.STOPPED);
    }

    public boolean isStopping() {
        return this.checkState(ManagedLifecycleThreadState.STOPPING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkState(ManagedLifecycleThreadState state) {
        this.runningLock.lock();
        try {
            boolean bl = this.state == state;
            return bl;
        }
        finally {
            this.runningLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRunning(ManagedLifecycleThreadState newState) {
        ManagedLifecycleThreadState origState;
        this.runningLock.lock();
        try {
            origState = this.state;
            this.state = newState;
            this.runningChanged.signalAll();
        }
        finally {
            this.runningLock.unlock();
        }
        this.fireStateChangedEvent(origState, newState);
    }

    public boolean waitUntilStopping(long terminationPeriod) {
        return this.waitForRunningStateChange(ManagedLifecycleThreadState.STOPPING, terminationPeriod);
    }

    public boolean waitUntilStopped() {
        return this.waitUntilStopped(this.getTerminationPeriod());
    }

    public boolean waitUntilStopped(long terminationPeriod) {
        return this.waitForRunningStateChange(ManagedLifecycleThreadState.STOPPED, terminationPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForRunningStateChange(ManagedLifecycleThreadState state, long terminationPeriod) {
        this.runningLock.lock();
        try {
            if (this.state != state) {
                long delay;
                long end = System.currentTimeMillis() + terminationPeriod;
                while (this.state != state && (delay = end - System.currentTimeMillis()) > 0L) {
                    this.runningChanged.await(delay, TimeUnit.MILLISECONDS);
                }
            }
            boolean end = this.state == state;
            this.runningLock.unlock();
            return end;
        }
        catch (Throwable throwable) {
            try {
                this.runningLock.unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Interrupted while waiting for running state change");
                }
                this.runningLock.lock();
                try {
                    boolean bl = this.state == state;
                    return bl;
                }
                finally {
                    this.runningLock.unlock();
                }
            }
        }
    }

    public void addManagedLifecycleThreadEventListener(ManagedLifecycleThreadEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeManagedLifecycleThreadEventListener(ManagedLifecycleThreadEventListener listener) {
        this.listeners.remove(listener);
    }

    private void fireStateChangedEvent(ManagedLifecycleThreadState origState, ManagedLifecycleThreadState newState) {
        if (this.listeners.size() > 0) {
            ManagedLifecycleThreadStateEvent event = new ManagedLifecycleThreadStateEvent(this, origState, newState);
            for (ManagedLifecycleThreadEventListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.state = ManagedLifecycleThreadState.STOPPED;
    }
}

