/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import org.apache.log4j.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.listeners.jca.ActivationBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss42ActivationBridge
implements ActivationBridge {
    private static Logger logger = Logger.getLogger(JBoss42ActivationBridge.class);
    protected static final String[] createActivationSpecSig = new String[]{Class.class.getName(), Collection.class.getName()};
    protected static final String[] activationSig = new String[]{MessageEndpointFactory.class.getName(), ActivationSpec.class.getName()};
    private String adapter;
    private Class messagingTypeClass;
    private MessageEndpointFactory messageEndpointFactory;
    private Map<String, String> activationProperties;
    private ActivationSpec activationSpec;
    private MBeanServer mbeanServer;
    private ObjectName resourceAdapterObjectName;

    @Override
    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    @Override
    public void setMessagingTypeClass(Class messagingTypeClass) {
        this.messagingTypeClass = messagingTypeClass;
    }

    @Override
    public void setMessageEndpointFactory(MessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    @Override
    public void setActivationProperties(Map<String, String> activationProperties) {
        this.activationProperties = activationProperties;
    }

    @Override
    public void activate() {
        this.mbeanServer = MBeanServerLocator.locateJBoss();
        try {
            this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.adapter + "'");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Unable to create JMX ObjectName to register adapter: " + this.adapter, e);
        }
        ArrayList<ActivationConfigPropertyMetaData> metaData = new ArrayList<ActivationConfigPropertyMetaData>();
        for (String key : this.activationProperties.keySet()) {
            String value = this.activationProperties.get(key);
            metaData.add(new ActivationConfigPropertyMetaData(key, value));
        }
        Object[] params = new Object[]{this.messagingTypeClass, metaData};
        try {
            this.activationSpec = (ActivationSpec)this.mbeanServer.invoke(this.resourceAdapterObjectName, "createActivationSpec", params, createActivationSpecSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            throw new RuntimeException("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
        }
        params = new Object[]{this.messageEndpointFactory, this.activationSpec};
        try {
            this.mbeanServer.invoke(this.resourceAdapterObjectName, "endpointActivation", params, activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            throw new RuntimeException("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec, t);
        }
    }

    @Override
    public void deactivate() {
        Object[] params = new Object[]{this.messageEndpointFactory, this.activationSpec};
        try {
            this.mbeanServer.invoke(this.resourceAdapterObjectName, "endpointDeactivation", params, activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            logger.warn((Object)("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec), t);
        }
    }
}

