/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.soa.esb.listeners.jca.EndpointContainer;
import org.jboss.soa.esb.listeners.jca.EndpointProxy;

public class EndpointFactory
implements MessageEndpointFactory {
    private EndpointContainer container;
    private Class messagingType;
    private ClassLoader loader;
    private Constructor proxyConstructor;

    public EndpointContainer getContainer() {
        return this.container;
    }

    public void setContainer(EndpointContainer container) {
        this.container = container;
    }

    public void setMessagingType(Class messagingType) {
        this.messagingType = messagingType;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void start() {
        Class[] interfaces = new Class[]{this.messagingType, MessageEndpoint.class};
        Class<?> proxyClass = Proxy.getProxyClass(this.loader, interfaces);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        try {
            this.proxyConstructor = proxyClass.getConstructor(constructorParams);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        EndpointProxy proxy = new EndpointProxy();
        proxy.setXaResource(xaResource);
        proxy.setMessageEndpointFactory(this);
        proxy.setContainer(this.container);
        proxy.setLoader(this.loader);
        Object[] args = new Object[]{proxy};
        try {
            return (MessageEndpoint)this.proxyConstructor.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.container.isDeliveryTransacted(method);
    }
}

