/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.cache.DeleteOnEvictTreeCacheListener;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.cache.FtpFileCacheException;
import org.jboss.soa.esb.util.ClassUtil;

public class FtpFileCache {
    private Logger log = Logger.getLogger(FtpFileCache.class);
    private static final String DEFAULT_CONFIG_FILE = "/ftpfile-cache-config.xml";
    private String fqn = "/ftp/cache/";
    private String config;
    private TreeCache treeCache;

    public FtpFileCache(String config) throws FtpFileCacheException {
        if (config == null) {
            config = DEFAULT_CONFIG_FILE;
        }
        this.config = config;
        InputStream in = null;
        try {
            this.treeCache = new TreeCache();
            in = this.getConfigInputStream(this.config);
            PropertyConfigurator configurator = new PropertyConfigurator();
            configurator.configure((Object)this.treeCache, in);
            this.close(in);
        }
        catch (Exception e) {
            try {
                this.log.error((Object)e);
                throw new FtpFileCacheException(e);
            }
            catch (Throwable throwable) {
                this.close(in);
                throw throwable;
            }
        }
    }

    protected InputStream getConfigInputStream(String path) {
        InputStream in = null;
        File configFile = new File(path);
        if (configFile.exists()) {
            this.log.debug((Object)("Reading jboss cache configuration from : " + path));
            try {
                in = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)e);
            }
        } else {
            this.log.debug((Object)("Reading jgroups configuration classpath : " + path));
            in = ClassUtil.getResourceAsStream(path, this.getClass());
        }
        return in;
    }

    public void start() throws FtpFileCacheException {
        try {
            this.treeCache.startService();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new FtpFileCacheException(e);
        }
    }

    public void stop() {
        this.treeCache.stopService();
    }

    public void putFileName(String fileName) throws CacheException {
        this.treeCache.put(this.fqn, (Object)fileName, (Object)fileName);
    }

    public Object getFileName(String fileName) throws CacheException {
        return this.treeCache.get(this.fqn, (Object)fileName);
    }

    public Object deleteFile(String fileName) throws CacheException {
        return this.treeCache.remove(this.fqn, (Object)fileName);
    }

    public boolean containsFile(String fileName) {
        return this.treeCache.exists(this.fqn, (Object)fileName);
    }

    public String getCache() {
        return this.treeCache.print(this.fqn);
    }

    public String getFqn() {
        return this.fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    public String getConfigFile() {
        return this.config;
    }

    public void removeAll() throws CacheException {
        this.treeCache.removeData(this.fqn);
    }

    public void setDeleteOnEviction() {
        this.treeCache.addTreeCacheListener((TreeCacheListener)new DeleteOnEvictTreeCacheListener(this.treeCache));
    }

    public void addCacheListener(TreeCacheListener listener) {
        if (listener != null) {
            this.treeCache.addTreeCacheListener(listener);
        }
    }

    public Map getCacheListeners() {
        return this.treeCache.getTreeCacheListeners();
    }

    public void setCacheListener(Class cacheListenerClass) throws FtpFileCacheException {
        if (cacheListenerClass == null) {
            return;
        }
        try {
            Constructor constructor = cacheListenerClass.getConstructor(TreeCache.class);
            Object object = constructor.newInstance(this.treeCache);
            if (object instanceof TreeCacheListener) {
                TreeCacheListener listener = (TreeCacheListener)object;
                this.treeCache.addTreeCacheListener(listener);
            }
        }
        catch (SecurityException e) {
            throw this.createFtpFileCacheException("SecurityException while trying set the CacheListener:", e);
        }
        catch (NoSuchMethodException e) {
            throw this.createFtpFileCacheException("NoSuchMethodException while trying set the CacheListener:", e);
        }
        catch (IllegalArgumentException e) {
            throw this.createFtpFileCacheException("IllegalArgumentException while trying set the CacheListener:", e);
        }
        catch (InstantiationException e) {
            throw this.createFtpFileCacheException("InstantiationException while trying set the CacheListener:", e);
        }
        catch (IllegalAccessException e) {
            throw this.createFtpFileCacheException("IllegalAccessException while trying set the CacheListener:", e);
        }
        catch (InvocationTargetException e) {
            throw this.createFtpFileCacheException("InvocationTargetException while trying set the CacheListener:", e);
        }
    }

    private FtpFileCacheException createFtpFileCacheException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        return new FtpFileCacheException(e);
    }

    private void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            this.log.warn((Object)"Error while trying to close Closable", (Throwable)e);
        }
    }

    public void destroy() {
        this.log.info((Object)"destroy method of FtpFileCache called");
        this.treeCache.destroy();
    }
}

