/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.RemoteFileSystemStrategy;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.RemoteFileSystemStrategyException;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.cache.FtpFileCache;
import org.jboss.soa.esb.listeners.gateway.remotestrategies.cache.FtpFileCacheException;

public class ReadOnlyRemoteFileSystemStrategy
implements RemoteFileSystemStrategy {
    private Logger log = Logger.getLogger(ReadOnlyRemoteFileSystemStrategy.class);
    private FtpFileCache ftpFileCache;

    public void init(String configFile) throws RemoteFileSystemStrategyException {
        try {
            this.ftpFileCache = new FtpFileCache(configFile);
            this.ftpFileCache.start();
        }
        catch (FtpFileCacheException e) {
            throw new RemoteFileSystemStrategyException(e);
        }
    }

    public boolean deleteFile(File file) throws RemoteFileSystemStrategyException {
        return true;
    }

    public boolean renameFile(File from, File to) throws RemoteFileSystemStrategyException {
        return true;
    }

    public File getWorkFileName(File file, String suffix) {
        return file;
    }

    public File[] filterFileList(File[] files) throws RemoteFileSystemStrategyException {
        if (files == null) {
            return files;
        }
        ArrayList<File> newFileList = new ArrayList<File>();
        for (File file : files) {
            String fileName = file.getName();
            if (this.ftpFileCache.containsFile(fileName)) continue;
            try {
                this.ftpFileCache.putFileName(fileName);
                newFileList.add(file);
            }
            catch (CacheException e) {
                this.log.error((Object)("Exception while trying to put file : " + fileName + " into the cache"), (Throwable)e);
            }
        }
        return newFileList.toArray(new File[0]);
    }

    public void removeAllData() throws CacheException {
        this.ftpFileCache.removeAll();
    }

    public void stop() {
        this.ftpFileCache.stop();
    }

    public void destroy() {
        this.ftpFileCache.destroy();
    }

    public void setDeleteOnEviction() {
        this.ftpFileCache.setDeleteOnEviction();
    }

    public Map getCacheListeners() {
        return this.ftpFileCache.getCacheListeners();
    }

    public void setCacheListener(Class cacheListenerClass) throws RemoteFileSystemStrategyException {
        try {
            this.ftpFileCache.setCacheListener(cacheListenerClass);
        }
        catch (FtpFileCacheException e) {
            throw new RemoteFileSystemStrategyException(e);
        }
    }
}

