/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.gateway.PackageJmsMessageContents;
import org.jboss.soa.esb.listeners.lifecycle.AbstractThreadedManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleThreadState;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.jboss.soa.esb.util.ClassUtil;

public class JmsGatewayListener
extends AbstractThreadedManagedLifecycle {
    private static final long serialVersionUID = 5070422864110923930L;
    protected static final Logger _logger = Logger.getLogger(JmsGatewayListener.class);
    protected String jmsDestinationName;
    protected JmsSession jmsSession;
    protected Destination jmsDestination;
    protected MessageConsumer jmsMessageConsumer;
    protected String _messageSelector;
    protected ConfigTree _config;
    protected String _serviceCategory;
    protected String _serviceName;
    protected String _targetServiceCategory;
    protected String _targetServiceName;
    protected EPR _myEpr;
    protected ServiceInvoker _serviceInvoker;
    protected String _composerName;
    protected Class _composerClass;
    protected Object _composer;
    protected Method _processMethod;
    protected JmsConnectionPool jmsConnectionPool;
    private static final long MIN_ERROR_DELAY = 1000L;
    private static final long MAX_ERROR_DELAY = 32000L;
    private long errorDelay;

    public JmsGatewayListener(ConfigTree listenerConfig) throws ConfigurationException {
        super(listenerConfig);
        this._config = listenerConfig;
        this.checkMyParms();
    }

    protected void doInitialise() throws ManagedLifecycleException {
        try {
            List<EPR> _targetEprs = RegistryUtil.getEprs(this._targetServiceCategory, this._targetServiceName);
            if (null == _targetEprs || _targetEprs.size() < 1) {
                throw new ManagedLifecycleException("EPR <" + this._targetServiceName + "> not found in registry");
            }
        }
        catch (ServiceNotFoundException snfe) {
            throw new ManagedLifecycleException("EPR <" + this._targetServiceName + " " + this._targetServiceName + "> not found in registry");
        }
        catch (RegistryException re) {
            throw new ManagedLifecycleException("Unexpected registry exception", re);
        }
        try {
            this._serviceInvoker = new ServiceInvoker(this._targetServiceCategory, this._targetServiceName);
        }
        catch (MessageDeliverException e) {
            throw new ManagedLifecycleException(e);
        }
        try {
            this.prepareMessageReceiver();
        }
        catch (ConnectionException ce) {
            throw new ManagedLifecycleException("Unexpected connection exception from prepareMessageReceiver", ce);
        }
        catch (JMSException jmse) {
            throw new ManagedLifecycleException("Unexpected JMS error from prepareMessageReceiver", jmse);
        }
        catch (ConfigurationException ce) {
            throw new ManagedLifecycleException("Unexpected configuration exception from prepareMessageReceiver", ce);
        }
        catch (NamingContextException nce) {
            throw new ManagedLifecycleException("Unexpected naming context exception from prepareMessageReceiver", nce);
        }
        if (this._serviceName != null) {
            try {
                RegistryUtil.register(this._config, this._myEpr);
            }
            catch (RegistryException re) {
                throw new ManagedLifecycleException("Unexpected error during registration for epr " + this._myEpr, re);
            }
        }
    }

    protected void doRun() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("run() method of " + this.getClass().getSimpleName() + " started on thread " + Thread.currentThread().getName()));
        }
        while (this.isRunning()) {
            javax.jms.Message msgIn = this.receiveOne();
            if (null == msgIn) continue;
            try {
                Object obj = this._processMethod.invoke(this._composer, msgIn);
                if (null == obj) {
                    _logger.warn((Object)("Action class method <" + this._processMethod.getName() + "> returned a null object"));
                } else {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("org.jboss.soa.esb.gateway.config", this._config);
                    obj = FilterManager.getInstance().doOutputWork((Message)obj, params);
                    try {
                        Message message = (Message)obj;
                        this._serviceInvoker.deliverAsync(message);
                    }
                    catch (ClassCastException e) {
                        _logger.error((Object)("Action class method <" + this._processMethod.getName() + "> returned a non Message object"), (Throwable)e);
                        this.rollbackJMSTransaction();
                    }
                }
                if (this.jmsSession.getTransacted()) {
                    this.jmsSession.commit();
                    continue;
                }
                msgIn.acknowledge();
            }
            catch (InvocationTargetException e) {
                _logger.error((Object)("Problems invoking method <" + this._processMethod.getName() + ">"), (Throwable)e);
                this.rollbackJMSTransaction();
            }
            catch (IllegalAccessException e) {
                _logger.error((Object)("Problems invoking method <" + this._processMethod.getName() + ">"), (Throwable)e);
                this.rollbackJMSTransaction();
            }
            catch (Exception e) {
                _logger.error((Object)"Unexpected problem", (Throwable)e);
                this.rollbackJMSTransaction();
            }
        }
        _logger.debug((Object)("run() method of " + this.getClass().getSimpleName() + " finished on thread " + Thread.currentThread().getName()));
    }

    protected void doThreadedDestroy() throws ManagedLifecycleException {
        this.cleanup();
    }

    private void rollbackJMSTransaction() {
        try {
            if (this.jmsSession.getTransacted()) {
                this.jmsSession.rollback();
            } else {
                this.releaseSession();
            }
        }
        catch (JMSException jmse) {
            this.releaseSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession() {
        if (this.jmsSession != null) {
            try {
                this.jmsConnectionPool.releaseSession(this.jmsSession);
            }
            finally {
                this.jmsSession = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void cleanup() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkMyParms() throws ConfigurationException {
        this._targetServiceCategory = ListenerUtil.getValue(this._config, "target-service-category", null);
        this._targetServiceName = ListenerUtil.getValue(this._config, "target-service-name", null);
        if (this._targetServiceCategory == null) {
            throw new ConfigurationException("No service category defined!");
        }
        if (this._targetServiceName == null) {
            throw new ConfigurationException("No service name defined!");
        }
        this.jmsDestinationName = ListenerUtil.getValue(this._config, "destination-name", null);
        if (this.jmsDestinationName == null) {
            throw new ConfigurationException("No queue name defined!");
        }
        this.resolveComposerClass();
        this._messageSelector = this._config.getAttribute("message-selector");
        _logger.debug((Object)"No value specified for: message-selector - All messages in queue will be received by this listener");
    }

    protected void resolveComposerClass() throws ConfigurationException {
        try {
            String sProcessMethod = null;
            this._composerName = this._config.getAttribute("composer-class");
            if (null != this._composerName) {
                this._composerClass = ClassUtil.forName(this._composerName, this.getClass());
                Constructor oConst = this._composerClass.getConstructor(ConfigTree.class);
                this._composer = oConst.newInstance(this._config);
                sProcessMethod = this._config.getAttribute("composer-process", "process");
            } else {
                this._composerName = PackageJmsMessageContents.class.getName();
                this._composerClass = PackageJmsMessageContents.class;
                this._composer = new PackageJmsMessageContents(PackageJmsMessageContents.createPayloadProxy(this._config));
                sProcessMethod = "process";
                _logger.debug((Object)("No <action> element found in configuration -  Using default composer class : " + this._composerName));
            }
            this._processMethod = this._composerClass.getMethod(sProcessMethod, Object.class);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareMessageReceiver() throws ConfigurationException, JMSException, ConnectionException, NamingContextException {
        block18: {
            this.jmsSession = null;
            this.jmsDestination = null;
            Properties environment = new Properties();
            String sJndiURL = this._config.getAttribute("jndi-URL");
            String sJndiContextFactory = this._config.getAttribute("jndi-context-factory");
            String sJndiPkgPrefix = this._config.getAttribute("jndi-pkg-prefix");
            if (sJndiURL != null) {
                environment.setProperty("java.naming.provider.url", sJndiURL);
            }
            if (sJndiContextFactory != null) {
                environment.setProperty("java.naming.factory.initial", sJndiContextFactory);
            }
            if (sJndiPkgPrefix != null) {
                environment.setProperty("java.naming.factory.url.pkgs", sJndiPkgPrefix);
            }
            Set<String> names = this._config.getAttributeNames();
            String jndiPrefixesValue = this._config.getAttribute("jndi-prefixes");
            if (jndiPrefixesValue != null) {
                environment.setProperty("jndi-prefixes", jndiPrefixesValue);
            }
            String[] jndiPrefixes = JMSEpr.getJndiPrefixes(jndiPrefixesValue);
            block9: for (String name : names) {
                for (String jndiPrefix : jndiPrefixes) {
                    if (!name.startsWith(jndiPrefix)) continue;
                    environment.setProperty(name, this._config.getAttribute(name));
                    continue block9;
                }
            }
            Context oJndiCtx = NamingContextPool.getNamingContext(environment);
            try {
                String sFactClass = ListenerUtil.getValue(this._config, "connection-factory", "ConnectionFactory");
                if (null == this._config.getAttribute("connection-factory")) {
                    _logger.debug((Object)("No value specified for connection-factory attribute -  Using default of: '" + sFactClass + "'"));
                }
                this._serviceCategory = this._config.getAttribute("service-category");
                this._serviceName = this._config.getAttribute("service-name");
                String destType = this._config.getAttribute("destination-type");
                boolean persistent = Boolean.valueOf(this._config.getAttribute("persistent"));
                boolean transacted = Boolean.valueOf(this._config.getAttribute("transacted"));
                String acknowledgeMode = this._config.getAttribute("acknowledge-mode");
                String username = this._config.getAttribute("jms-security-principal");
                String password = this._config.getAttribute("jms-security-credential");
                if (username != null && password != null) {
                    environment.put("jms-security-principal", username);
                    environment.put("jms-security-credential", password);
                }
                _logger.debug((Object)("JMSGateway isTransacted = " + transacted));
                this._myEpr = null == this._serviceName ? null : new JMSEpr("1.1", destType, this.jmsDestinationName, sFactClass, environment, this._messageSelector, persistent, acknowledgeMode, username, password, transacted);
                this.jmsConnectionPool = JmsConnectionPoolContainer.getPool(environment, sFactClass, username, password);
                try {
                    this.jmsSession = this._myEpr != null ? this.jmsConnectionPool.getSession(((JMSEpr)this._myEpr).getAcknowledgeMode()) : this.jmsConnectionPool.getSession(1);
                }
                catch (NamingException ne) {
                    throw new ConfigurationException("Failed to obtain queue session from pool", ne);
                }
                try {
                    this.jmsDestination = (Destination)oJndiCtx.lookup(this.jmsDestinationName);
                }
                catch (NamingException nex) {
                    try {
                        oJndiCtx = NamingContextPool.replaceNamingContext(oJndiCtx, environment);
                        this.jmsDestination = (Destination)oJndiCtx.lookup(this.jmsDestinationName);
                    }
                    catch (NamingException ne) {
                        if ("queue".equals(destType)) {
                            this.jmsDestination = this.jmsSession.createQueue(this.jmsDestinationName);
                            break block18;
                        }
                        this.jmsDestination = this.jmsSession.createTopic(this.jmsDestinationName);
                    }
                }
            }
            finally {
                NamingContextPool.releaseNamingContext(oJndiCtx);
            }
        }
        this.jmsMessageConsumer = this.jmsSession.createConsumer(this.jmsDestination, this._messageSelector);
    }

    protected javax.jms.Message receiveOne() {
        while (this.isRunning()) {
            try {
                javax.jms.Message ret = this.jmsMessageConsumer.receive(200L);
                if (null == ret) continue;
                return ret;
            }
            catch (JMSException oJ) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"JMS error on receive.  Attempting JMS Destination reconnect.", (Throwable)oJ);
                }
                try {
                    this.prepareMessageReceiver();
                    this.errorDelay = 0L;
                }
                catch (Exception e) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)"Reconnecting to Queue", (Throwable)e);
                    }
                    if (this.errorDelay == 0L) {
                        this.errorDelay = 1000L;
                    } else if (this.errorDelay < 32000L) {
                        this.errorDelay <<= 1;
                    }
                    _logger.warn((Object)("Error reconnecting to Queue, backing off for " + this.errorDelay + " milliseconds"));
                    this.waitForRunningStateChange(ManagedLifecycleThreadState.STOPPING, this.errorDelay);
                }
            }
        }
        return null;
    }
}

