/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.AbstractFileGateway;
import org.jboss.soa.esb.listeners.gateway.GatewayException;
import org.jboss.soa.esb.listeners.gateway.LocalFileMessageComposer;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.Util;

public class FileGatewayListener
extends AbstractFileGateway {
    private static final long serialVersionUID = 8457176329093772449L;
    private FileFilter _inputFileFilter;
    private FileFilter _ignoreFileFilter;

    public FileGatewayListener(ConfigTree config) throws ConfigurationException, RegistryException, GatewayException {
        super(config);
        if (this._inputSuffix == null || this._inputSuffix.equals("")) {
            this._inputFileFilter = null;
            this._ignoreFileFilter = new IgnoreFile(this._workingSuffix, this._errorSuffix, this._postProcessSuffix);
        } else {
            this._inputFileFilter = new FileEndsWith(this._inputSuffix);
        }
    }

    protected void seeIfOkToWorkOnDir(File p_oDir) throws ConfigurationException {
        if (!p_oDir.exists()) {
            throw new ConfigurationException("Directory " + p_oDir.toString() + " not found");
        }
        if (!p_oDir.isDirectory()) {
            throw new ConfigurationException(p_oDir.toString() + " is not a directory");
        }
        if (!p_oDir.canRead()) {
            throw new ConfigurationException("Can't read directory " + p_oDir.toString());
        }
        if (!p_oDir.canWrite()) {
            throw new ConfigurationException("Can't write/rename in directory " + p_oDir.toString());
        }
    }

    boolean deleteFile(File file) throws GatewayException {
        return file.delete();
    }

    byte[] getFileContents(File file) throws GatewayException {
        try {
            int iQread;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] ba = new byte[1000];
            FileInputStream inp = new FileInputStream(file);
            while (-1 != (iQread = inp.read(ba))) {
                if (iQread <= 0) continue;
                out.write(ba, 0, iQread);
            }
            inp.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GatewayException(e);
        }
    }

    File[] getFileList() throws GatewayException {
        if (this._inputFileFilter != null) {
            return this.filterFiles(this._inputDirectory, this._inputFileFilter);
        }
        return this.filterFiles(this._inputDirectory, this._ignoreFileFilter);
    }

    private File[] filterFiles(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            _logger.warn((Object)("Error applying file filter '" + filter + "' to directory '" + dir.getAbsolutePath() + "'.  Null file list returned.  Invalid directory, or IO error reading directory."));
        }
        return files;
    }

    boolean renameFile(File from, File to) throws GatewayException {
        return FileUtil.renameTo(from, to);
    }

    String getDefaultComposer() {
        return LocalFileMessageComposer.class.getName();
    }

    void bytesToFile(byte[] bytes, File file) throws GatewayException {
        try {
            if (file.exists() && !file.delete()) {
                throw new GatewayException("Unable to delete existing file " + file);
            }
            FileOutputStream out = new FileOutputStream(file);
            out.write(bytes);
            out.close();
        }
        catch (Exception e) {
            throw new GatewayException(e);
        }
    }

    protected void checkInputSuffix() throws ConfigurationException {
        if (this._inputSuffix == null) {
            this._inputSuffix = "";
        }
    }

    private class IgnoreFile
    implements FileFilter {
        String _workSuffix;
        String _errorSuffix;
        String _postSuffix;

        IgnoreFile(String workSuffix, String errorSuffix, String postSuffix) throws ConfigurationException {
            this._workSuffix = workSuffix;
            this._errorSuffix = errorSuffix;
            this._postSuffix = postSuffix;
            if (Util.isNullString(this._workSuffix)) {
                throw new ConfigurationException("Must specify workSuffix");
            }
            if (Util.isNullString(this._errorSuffix)) {
                throw new ConfigurationException("Must specify errorSuffix");
            }
            if (Util.isNullString(this._postSuffix)) {
                throw new ConfigurationException("Must specify postProcessSuffix");
            }
        }

        public boolean accept(File p_f) {
            if (p_f.isFile()) {
                String fileName = p_f.toString();
                return !fileName.endsWith(this._workSuffix) && !fileName.endsWith(this._errorSuffix) && !fileName.endsWith(this._postSuffix);
            }
            return false;
        }
    }

    private class FileEndsWith
    implements FileFilter {
        String m_sSuffix;

        FileEndsWith(String p_sEnd) throws ConfigurationException {
            this.m_sSuffix = p_sEnd;
            if (Util.isNullString(this.m_sSuffix)) {
                throw new ConfigurationException("Must specify file extension");
            }
        }

        public boolean accept(File p_f) {
            return p_f.isFile() ? p_f.toString().endsWith(this.m_sSuffix) : false;
        }
    }
}

