/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.mappers.MapperUtil;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActivationConfigDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JmsBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JmsJcaProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JmsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JmsMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JmsProviderType;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel.PropertyDocument;
import org.jboss.soa.esb.listeners.gateway.JmsGatewayListener;
import org.jboss.soa.esb.listeners.gateway.PackageJmsMessageContents;
import org.jboss.soa.esb.listeners.jca.JcaGatewayListener;
import org.jboss.soa.esb.listeners.jca.JcaJMSInflowMessageProcessorAdapter;
import org.jboss.soa.esb.listeners.jca.JcaJMSMessageAwareComposer;
import org.jboss.soa.esb.listeners.jca.JcaMessageAwareListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsListenerMapper {
    private static Logger log = Logger.getLogger(JmsListenerMapper.class);

    public static Element map(Element root, JmsListenerDocument.JmsListener listener, Generator.XMLBeansModel model) throws ConfigurationException {
        Class gatewayClass;
        JmsProviderType provider;
        JmsBusDocument.JmsBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (JmsBusDocument.JmsBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <jms-listener> must reference a <jms-bus>.");
        }
        try {
            provider = (JmsProviderType)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <jms-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        JmsMessageFilterDocument.JmsMessageFilter messageFilter = listener.getJmsMessageFilter();
        if (messageFilter == null && (messageFilter = bus.getJmsMessageFilter()) == null) {
            throw new ConfigurationException("No <jms-detination> defined on either <jms-listener> [" + listener.getName() + "] or <jms-bus> [" + bus.getBusid() + "].");
        }
        if (provider instanceof JmsJcaProviderDocument.JmsJcaProvider) {
            JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider = (JmsJcaProviderDocument.JmsJcaProvider)provider;
            JmsListenerMapper.mapJmsJcaAttributes(listener, listenerNode, jmsJcaProvider, messageFilter);
            gatewayClass = JcaGatewayListener.class;
        } else {
            gatewayClass = JmsGatewayListener.class;
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("gatewayClass", gatewayClass.getName());
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            JmsListenerMapper.mapJmsEprProperties(listenerNode, provider, messageFilter);
            listenerNode.setAttribute("protocol", "jms");
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            JmsListenerMapper.mapJmsEprProperties(eprNode, provider, messageFilter);
            eprNode.setAttribute("protocol", "jms");
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapJmsEprProperties(Element toElement, JmsProviderType provider, JmsMessageFilterDocument.JmsMessageFilter messageFilter) {
        if (messageFilter.getDestType() == JmsMessageFilterDocument.JmsMessageFilter.DestType.QUEUE) {
            toElement.setAttribute("destination-type", "queue");
        } else {
            toElement.setAttribute("destination-type", "topic");
        }
        toElement.setAttribute("destination-name", messageFilter.getDestName());
        toElement.setAttribute("message-selector", messageFilter.getSelector());
        toElement.setAttribute("connection-factory", provider.getConnectionFactory());
        toElement.setAttribute("jndi-context-factory", provider.getJndiContextFactory());
        toElement.setAttribute("jndi-pkg-prefix", provider.getJndiPkgPrefix());
        toElement.setAttribute("jndi-URL", provider.getJndiURL());
        toElement.setAttribute("persistent", Boolean.toString(messageFilter.getPersistent()));
        toElement.setAttribute("acknowledge-mode", messageFilter.getAcknowledgeMode());
        toElement.setAttribute("jms-security-principal", messageFilter.getJmsSecurityPrincipal());
        toElement.setAttribute("jms-security-credential", messageFilter.getJmsSecurityCredential());
        toElement.setAttribute("transacted", Boolean.toString(messageFilter.getTransacted()));
    }

    private static void mapJmsJcaAttributes(JmsListenerDocument.JmsListener listener, Element listenerNode, JmsJcaProviderDocument.JmsJcaProvider jmsJcaProvider, JmsMessageFilterDocument.JmsMessageFilter messageFilter) throws ConfigurationException {
        int destType;
        JmsListenerMapper.setAttribute(listenerNode, "adapter", jmsJcaProvider.getAdapter(), "jms-ra.rar");
        JmsListenerMapper.setAttribute(listenerNode, "endpointClass", jmsJcaProvider.getEndpointClass(), JcaJMSInflowMessageProcessorAdapter.class.getName());
        JmsListenerMapper.setAttribute(listenerNode, "messagingType", jmsJcaProvider.getMessagingType());
        JmsListenerMapper.setAttribute(listenerNode, "jcaBridge", jmsJcaProvider.getJcaBridge());
        boolean transacted = jmsJcaProvider.isSetTransacted() ? jmsJcaProvider.getTransacted() : true;
        JmsListenerMapper.setAttribute(listenerNode, "transacted", Boolean.toString(transacted));
        if (listener.getIsGateway()) {
            JmsListenerMapper.setAttribute(listenerNode, "composer-class", PackageJmsMessageContents.class.getName());
            JmsListenerMapper.setAttribute(listenerNode, "composer-process", "process");
        } else {
            JmsListenerMapper.setAttribute(listenerNode, "listenerClass", JcaMessageAwareListener.class.getName());
            JmsListenerMapper.setAttribute(listenerNode, "listener-composer", JcaJMSMessageAwareComposer.class.getName());
        }
        Element activationConfigElement = YADOMUtil.addElement(listenerNode, "activation-config");
        JmsListenerMapper.addPropertyElement(activationConfigElement, "destination", messageFilter.getDestName());
        if (jmsJcaProvider.isSetProviderAdapterJNDI()) {
            JmsListenerMapper.addPropertyElement(activationConfigElement, "providerAdapterJNDI", jmsJcaProvider.getProviderAdapterJNDI());
        }
        if ((destType = messageFilter.getDestType().intValue()) == 1) {
            JmsListenerMapper.addPropertyElement(activationConfigElement, "destinationType", Queue.class.getName());
        } else if (destType == 2) {
            JmsListenerMapper.addPropertyElement(activationConfigElement, "destinationType", Topic.class.getName());
        } else {
            throw new ConfigurationException("Unknown destination type: " + messageFilter.getDestType());
        }
        if (messageFilter.getSelector() != null) {
            JmsListenerMapper.addPropertyElement(activationConfigElement, "messageSelector", messageFilter.getSelector());
        }
        if (listener.getMaxThreads() > 0) {
            JmsListenerMapper.addPropertyElement(activationConfigElement, "maxMessages", Integer.toString(listener.getMaxThreads()));
        }
        List<String> defaultPropertyNames = JmsListenerMapper.getDefaultActivationConfigNames(activationConfigElement);
        log.debug((Object)("Default activation-config properties :" + defaultPropertyNames));
        ActivationConfigDocument.ActivationConfig activationConfig = jmsJcaProvider.getActivationConfig();
        if (activationConfig != null) {
            List propertyList = activationConfig.getPropertyList();
            for (PropertyDocument.Property prop : propertyList) {
                if (defaultPropertyNames.contains(prop.getName())) {
                    throw new ConfigurationException("activation-config already contains [" + prop.getName() + "], which cannot be overridden");
                }
                JmsListenerMapper.addPropertyElement(activationConfigElement, prop.getName(), prop.getValue());
            }
        }
    }

    private static List<String> getDefaultActivationConfigNames(Element activationConfigElement) {
        NodeList defaultActivationProperties = activationConfigElement.getElementsByTagName("property");
        ArrayList<String> defaultPropertyNames = new ArrayList<String>(5);
        int i = defaultActivationProperties.getLength();
        while (i-- > 0) {
            defaultPropertyNames.add(defaultActivationProperties.item(i).getAttributes().getNamedItem("name").getNodeValue());
        }
        return defaultPropertyNames;
    }

    private static void setAttribute(Element listenerNode, String name, String value) {
        if (value != null) {
            listenerNode.setAttribute(name, value);
        }
    }

    private static void setAttribute(Element listenerNode, String name, String value, String defaultValue) {
        if (value == null) {
            listenerNode.setAttribute(name, defaultValue);
        } else {
            listenerNode.setAttribute(name, value);
        }
    }

    private static void addPropertyElement(Element activationConfigElement, String name, String value) {
        Element propertyElement = YADOMUtil.addElement(activationConfigElement, "property");
        propertyElement.setAttribute("name", name);
        propertyElement.setAttribute("value", value);
    }
}

